/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.redstone_relay;

import com.mrh0.createaddition.CreateAddition;
import com.mrh0.createaddition.blocks.connector.ConnectorType;
import com.mrh0.createaddition.blocks.redstone_relay.RedstoneRelayBlock;
import com.mrh0.createaddition.compat.computercraft.Peripherals;
import com.mrh0.createaddition.compat.computercraft.RedstoneRelayPeripheral;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.LocalNode;
import com.mrh0.createaddition.energy.NodeRotation;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.network.EnergyNetworkPacket;
import com.mrh0.createaddition.network.IObserveTileEntity;
import com.mrh0.createaddition.network.ObservePacket;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class RedstoneRelayBlockEntity
extends SmartBlockEntity
implements IWireNode,
IHaveGoggleInformation,
IObserveTileEntity {
    private final Set<LocalNode> wireCache = new HashSet<LocalNode>();
    private final LocalNode[] localNodes = new LocalNode[this.getNodeCount()];
    private final IWireNode[] nodeCache = new IWireNode[this.getNodeCount()];
    private EnergyNetwork networkIn;
    private EnergyNetwork networkOut;
    private int demand = 0;
    private int throughput = 0;
    private boolean wasContraption = false;
    private boolean firstTick = true;
    public static Vec3 OFFSET_NORTH = new Vec3(0.0, -0.0625, -0.3125);
    public static Vec3 OFFSET_WEST = new Vec3(-0.3125, -0.0625, 0.0);
    public static Vec3 OFFSET_SOUTH = new Vec3(0.0, -0.0625, 0.3125);
    public static Vec3 OFFSET_EAST = new Vec3(0.3125, -0.0625, 0.0);
    public static Vec3 IN_VERTICAL_OFFSET_NORTH = new Vec3(0.3125, 0.0, -0.0625);
    public static Vec3 IN_VERTICAL_OFFSET_WEST = new Vec3(-0.0625, 0.0, -0.3125);
    public static Vec3 IN_VERTICAL_OFFSET_SOUTH = new Vec3(-0.3125, 0.0, 0.0625);
    public static Vec3 IN_VERTICAL_OFFSET_EAST = new Vec3(0.0625, 0.0, 0.3125);
    public static Vec3 OUT_VERTICAL_OFFSET_NORTH = new Vec3(-0.3125, 0.0, -0.0625);
    public static Vec3 OUT_VERTICAL_OFFSET_WEST = new Vec3(-0.0625, 0.0, 0.3125);
    public static Vec3 OUT_VERTICAL_OFFSET_SOUTH = new Vec3(0.3125, 0.0, 0.0625);
    public static Vec3 OUT_VERTICAL_OFFSET_EAST = new Vec3(0.0625, 0.0, -0.3125);
    public static final int NODE_COUNT = 8;
    protected LazyOptional<RedstoneRelayPeripheral> peripheral;

    public RedstoneRelayBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        if (CreateAddition.CC_ACTIVE) {
            this.peripheral = LazyOptional.of(() -> Peripherals.createRedstoneRelayPeripheral(this));
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> list) {
    }

    @Override
    @Nullable
    public IWireNode getWireNode(int index) {
        return IWireNode.getWireNodeFrom(index, this, this.localNodes, this.nodeCache, this.f_58857_);
    }

    @Override
    @Nullable
    public LocalNode getLocalNode(int index) {
        return this.localNodes[index];
    }

    @Override
    public void setNode(int index, int other, BlockPos pos, WireType type) {
        this.localNodes[index] = new LocalNode((BlockEntity)this, index, other, type, pos);
        this.notifyUpdate();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
    }

    @Override
    public void removeNode(int index, boolean dropWire) {
        LocalNode old = this.localNodes[index];
        this.localNodes[index] = null;
        this.invalidateNodeCache();
        this.notifyUpdate();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
        if (dropWire && old != null) {
            this.wireCache.add(old);
        }
    }

    @Override
    public int getNodeCount() {
        return 8;
    }

    @Override
    public Vec3 getNodeOffset(int node) {
        boolean vertical = (Boolean)this.m_58900_().m_61143_((Property)RedstoneRelayBlock.VERTICAL);
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)RedstoneRelayBlock.HORIZONTAL_FACING);
        if (node > 3) {
            return switch (direction) {
                case Direction.NORTH -> {
                    if (vertical) {
                        yield OUT_VERTICAL_OFFSET_NORTH;
                    }
                    yield OFFSET_NORTH;
                }
                case Direction.WEST -> {
                    if (vertical) {
                        yield OUT_VERTICAL_OFFSET_WEST;
                    }
                    yield OFFSET_WEST;
                }
                case Direction.SOUTH -> {
                    if (vertical) {
                        yield OUT_VERTICAL_OFFSET_SOUTH;
                    }
                    yield OFFSET_SOUTH;
                }
                case Direction.EAST -> {
                    if (vertical) {
                        yield OUT_VERTICAL_OFFSET_EAST;
                    }
                    yield OFFSET_EAST;
                }
                default -> OFFSET_NORTH;
            };
        }
        return switch (direction) {
            case Direction.NORTH -> {
                if (vertical) {
                    yield IN_VERTICAL_OFFSET_NORTH;
                }
                yield OFFSET_SOUTH;
            }
            case Direction.WEST -> {
                if (vertical) {
                    yield IN_VERTICAL_OFFSET_WEST;
                }
                yield OFFSET_EAST;
            }
            case Direction.SOUTH -> {
                if (vertical) {
                    yield IN_VERTICAL_OFFSET_SOUTH;
                }
                yield OFFSET_NORTH;
            }
            case Direction.EAST -> {
                if (vertical) {
                    yield IN_VERTICAL_OFFSET_EAST;
                }
                yield OFFSET_WEST;
            }
            default -> OFFSET_NORTH;
        };
    }

    @Override
    public int getAvailableNode(Vec3 pos) {
        Direction dir = (Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)RedstoneRelayBlock.HORIZONTAL_FACING);
        boolean vertical = (Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)RedstoneRelayBlock.VERTICAL);
        boolean upper = true;
        pos = pos.m_82492_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_());
        if (vertical) {
            switch (dir) {
                case NORTH: {
                    upper = pos.m_7096_() < 0.5;
                    break;
                }
                case WEST: {
                    upper = pos.m_7094_() > 0.5;
                    break;
                }
                case SOUTH: {
                    upper = pos.m_7096_() > 0.5;
                    break;
                }
                case EAST: {
                    upper = pos.m_7094_() < 0.5;
                    break;
                }
            }
        } else {
            switch (dir) {
                case NORTH: {
                    upper = pos.m_7094_() < 0.5;
                    break;
                }
                case WEST: {
                    upper = pos.m_7096_() < 0.5;
                    break;
                }
                case SOUTH: {
                    upper = pos.m_7094_() > 0.5;
                    break;
                }
                case EAST: {
                    upper = pos.m_7096_() > 0.5;
                    break;
                }
            }
        }
        for (int i = upper ? 4 : 0; i < (upper ? 8 : 4); ++i) {
            if (this.hasConnection(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isNodeInput(int node) {
        return node < 4;
    }

    @Override
    public boolean isNodeOutput(int node) {
        return !this.isNodeInput(node);
    }

    @Override
    public BlockPos getPos() {
        return this.m_58899_();
    }

    @Override
    public EnergyNetwork getNetwork(int node) {
        return this.isNodeInput(node) ? this.networkIn : this.networkOut;
    }

    @Override
    public void setNetwork(int node, EnergyNetwork network) {
        if (this.isNodeInput(node)) {
            this.networkIn = network;
        }
        if (this.isNodeOutput(node)) {
            this.networkOut = network;
        }
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (!clientPacket && nbt.m_128441_("node0")) {
            this.convertOldNbt(nbt);
            this.m_6596_();
        }
        this.invalidateLocalNodes();
        this.invalidateNodeCache();
        ListTag nodes = nbt.m_128437_("nodes", 10);
        nodes.forEach(tag -> {
            LocalNode localNode;
            this.localNodes[localNode.getIndex()] = localNode = new LocalNode((BlockEntity)this, (CompoundTag)tag);
        });
        if (nbt.m_128441_("contraption") && !clientPacket) {
            this.wasContraption = nbt.m_128471_("contraption");
            NodeRotation rotation = (NodeRotation)((Object)this.m_58900_().m_61143_(NodeRotation.ROTATION));
            if (rotation != NodeRotation.NONE) {
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(NodeRotation.ROTATION, (Comparable)((Object)NodeRotation.NONE)), 0);
            }
            for (LocalNode localNode : this.localNodes) {
                if (localNode == null) continue;
                localNode.updateRelative(rotation);
            }
        }
        if (!nodes.isEmpty() && this.networkIn != null && this.networkOut != null) {
            this.networkIn.invalidate();
            this.networkOut.invalidate();
        }
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        ListTag nodes = new ListTag();
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode localNode = this.localNodes[i];
            if (localNode == null) continue;
            CompoundTag tag = new CompoundTag();
            localNode.write(tag);
            nodes.add((Object)tag);
        }
        nbt.m_128365_("nodes", (Tag)nodes);
    }

    private void validateNodes() {
        boolean changed = this.validateLocalNodes(this.localNodes);
        this.notifyUpdate();
        if (changed) {
            this.invalidateNodeCache();
            if (this.networkIn != null) {
                this.networkIn.invalidate();
            }
            if (this.networkOut != null) {
                this.networkOut.invalidate();
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.firstTick) {
            this.firstTick = false;
            if (this.wasContraption && !this.f_58857_.m_5776_()) {
                this.wasContraption = false;
                this.validateNodes();
            }
        }
        if (!this.wireCache.isEmpty() && !this.m_58901_()) {
            this.handleWireCache(this.f_58857_, this.wireCache);
        }
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.networkTick();
    }

    private void networkTick() {
        if (this.awakeNetwork(this.f_58857_)) {
            this.notifyUpdate();
        }
        BlockState bs = this.m_58900_();
        this.throughput = 0;
        if (!bs.m_60713_((Block)CABlocks.REDSTONE_RELAY.get())) {
            return;
        }
        if (((Boolean)bs.m_61143_((Property)RedstoneRelayBlock.POWERED)).booleanValue()) {
            this.throughput = this.networkOut.push(this.networkIn.pull(this.demand));
            this.demand = this.networkIn.demand(this.networkOut.getDemand());
        }
    }

    public int getThroughput() {
        return this.throughput;
    }

    public void remove() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        for (int i = 0; i < this.getNodeCount(); ++i) {
            IWireNode otherNode;
            LocalNode localNode = this.getLocalNode(i);
            if (localNode == null || (otherNode = this.getWireNode(i)) == null) continue;
            int ourNode = localNode.getOtherIndex();
            if (localNode.isInvalid()) {
                otherNode.removeNode(ourNode);
                continue;
            }
            otherNode.removeNode(ourNode, true);
        }
        this.invalidateNodeCache();
        this.invalidateCaps();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
    }

    public void invalidateLocalNodes() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.localNodes[i] = null;
        }
    }

    @Override
    public void invalidateNodeCache() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.nodeCache[i] = null;
        }
    }

    @Override
    public boolean isNodeIndeciesConnected(int in, int other) {
        return this.isNodeInput(in) == this.isNodeInput(other);
    }

    @Override
    public ConnectorType getConnectorType() {
        return ConnectorType.Small;
    }

    public int getDemand() {
        return this.demand;
    }

    @Override
    public void onObserved(ServerPlayer player, ObservePacket pack) {
        if (this.isNetworkValid(pack.getNode())) {
            EnergyNetworkPacket.send(this.f_58858_, this.getNetwork(pack.getNode()).getPulled(), this.getNetwork(pack.getNode()).getPushed(), player);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (CreateAddition.CC_ACTIVE && Peripherals.isPeripheral(cap)) {
            return this.peripheral.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        HitResult ray = Minecraft.m_91087_().f_91077_;
        if (ray == null) {
            return false;
        }
        int node = this.getAvailableNode(ray.m_82450_());
        ObservePacket.send(this.f_58858_, node);
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"createaddition.tooltip.relay.info").m_130940_(ChatFormatting.WHITE)));
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"createaddition.tooltip.energy.selected").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237115_((String)(this.isNodeInput(node) ? "createaddition.tooltip.energy.push" : "createaddition.tooltip.energy.pull")).m_130940_(ChatFormatting.AQUA)));
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"createaddition.tooltip.energy.usage").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)Component.m_237113_((String)"    ").m_130946_(" ").m_130946_(Util.format(EnergyNetworkPacket.clientBuff)).m_130946_("fe/t").m_130940_(ChatFormatting.AQUA));
        return true;
    }

    @Override
    public int getMaxWireLength() {
        return (Integer)Config.SMALL_CONNECTOR_MAX_LENGTH.get();
    }
}

