/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.redstone_relay;

import com.mrh0.createaddition.blocks.redstone_relay.RedstoneRelayBlockEntity;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.NodeRotation;
import com.mrh0.createaddition.index.CABlockEntities;
import com.mrh0.createaddition.shapes.CAShapes;
import com.simibubi.create.content.contraptions.ITransformableBlock;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;

public class RedstoneRelayBlock
extends Block
implements IBE<RedstoneRelayBlockEntity>,
IWrenchable,
ITransformableBlock {
    public static final BooleanProperty VERTICAL = BooleanProperty.m_61465_((String)"vertical");
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final VoxelShape HORIZONTAL_SHAPE_MAIN = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape HORIZONTAL_SHAPE_X = Shapes.m_83124_((VoxelShape)HORIZONTAL_SHAPE_MAIN, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)6.0, (double)5.0, (double)7.0, (double)10.0), Block.m_49796_((double)11.0, (double)0.0, (double)6.0, (double)15.0, (double)7.0, (double)10.0)});
    public static final VoxelShape HORIZONTAL_SHAPE_Z = Shapes.m_83124_((VoxelShape)HORIZONTAL_SHAPE_MAIN, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)1.0, (double)10.0, (double)7.0, (double)5.0), Block.m_49796_((double)6.0, (double)0.0, (double)11.0, (double)10.0, (double)7.0, (double)15.0)});
    public static final VoxelShaper VERTICAL_SHAPE = CAShapes.shape(0.0, 0.0, 0.0, 16.0, 2.0, 16.0).add(1.0, 0.0, 6.0, 5.0, 7.0, 10.0).add(11.0, 0.0, 6.0, 15.0, 7.0, 10.0).forDirectional();
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);

    public RedstoneRelayBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)VERTICAL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(NodeRotation.ROTATION, (Comparable)((Object)NodeRotation.NONE)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
        if (((Boolean)state.m_61143_((Property)VERTICAL)).booleanValue()) {
            return VERTICAL_SHAPE.get(dir.m_122424_());
        }
        Direction.Axis axis = dir.m_122434_();
        return axis == Direction.Axis.X ? HORIZONTAL_SHAPE_X : HORIZONTAL_SHAPE_Z;
    }

    public Class<RedstoneRelayBlockEntity> getBlockEntityClass() {
        return RedstoneRelayBlockEntity.class;
    }

    public BlockEntityType<? extends RedstoneRelayBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CABlockEntities.REDSTONE_RELAY.get();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{VERTICAL, HORIZONTAL_FACING, POWERED, NodeRotation.ROTATION});
    }

    public BlockState m_5573_(BlockPlaceContext c) {
        if (c.m_43719_().m_122434_() == Direction.Axis.Y) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)(c.m_43723_().m_6144_() ? c.m_8125_().m_122428_() : c.m_8125_().m_122427_()))).m_61124_((Property)VERTICAL, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)c.m_43719_().m_122424_())).m_61124_((Property)VERTICAL, (Comparable)Boolean.valueOf(true));
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        boolean flag = (Boolean)state.m_61143_((Property)POWERED);
        boolean flag1 = this.shouldBePowered((Level)worldIn, pos, state);
        if (flag && !flag1) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
        } else if (!flag) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (state.m_60710_((LevelReader)worldIn, pos)) {
            this.updateState(worldIn, pos, state);
        } else {
            BlockEntity tileentity = state.m_155947_() ? worldIn.m_7702_(pos) : null;
            RedstoneRelayBlock.m_49892_((BlockState)state, (LevelAccessor)worldIn, (BlockPos)pos, (BlockEntity)tileentity);
            worldIn.m_7471_(pos, false);
            for (Direction direction : Direction.values()) {
                worldIn.m_46672_(pos.m_121945_(direction), (Block)this);
            }
        }
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        boolean vertical = (Boolean)state.m_61143_((Property)VERTICAL);
        Direction direction = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
        return RedstoneRelayBlock.m_49863_((LevelReader)world, (BlockPos)(vertical ? pos.m_121945_(direction) : pos.m_7495_()), (Direction)(vertical ? direction.m_122424_() : Direction.UP));
    }

    protected void updateState(Level worldIn, BlockPos pos, BlockState state) {
        boolean flag1;
        boolean flag = (Boolean)state.m_61143_((Property)POWERED);
        if (flag != (flag1 = this.shouldBePowered(worldIn, pos, state)) && !worldIn.m_183326_().m_183588_(pos, (Object)this)) {
            TickPriority tickpriority = TickPriority.VERY_HIGH;
            worldIn.m_186464_(pos, (Block)this, this.getDelay(state), tickpriority);
        }
    }

    private int getDelay(BlockState state) {
        return 2;
    }

    protected boolean shouldBePowered(Level worldIn, BlockPos pos, BlockState state) {
        return this.calculateInputStrength(worldIn, pos, state) > 0;
    }

    protected int calculateInputStrength(Level worldIn, BlockPos pos, BlockState state) {
        boolean vertical = (Boolean)state.m_61143_((Property)VERTICAL);
        if (vertical) {
            BlockPos blockpos1 = pos.m_121945_(Direction.UP);
            BlockPos blockpos2 = pos.m_121945_(Direction.DOWN);
            int i = Math.max(worldIn.m_46681_(blockpos1, Direction.DOWN), worldIn.m_46681_(blockpos2, Direction.UP));
            BlockState blockstate1 = worldIn.m_8055_(blockpos1);
            BlockState blockstate2 = worldIn.m_8055_(blockpos2);
            return Math.max(i, Math.max(blockstate1.m_60713_(Blocks.f_50088_) ? (Integer)blockstate1.m_61143_((Property)RedStoneWireBlock.f_55500_) : 0, blockstate2.m_60713_(Blocks.f_50088_) ? (Integer)blockstate2.m_61143_((Property)RedStoneWireBlock.f_55500_) : 0));
        }
        Direction direction = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
        BlockPos blockpos1 = pos.m_121945_(direction.m_122427_());
        BlockPos blockpos2 = pos.m_121945_(direction.m_122428_());
        int i = Math.max(worldIn.m_46681_(blockpos1, direction.m_122427_()), worldIn.m_46681_(blockpos2, direction.m_122428_()));
        int j = Math.max(worldIn.m_46852_(blockpos1, direction.m_122427_()), worldIn.m_46852_(blockpos2, direction.m_122428_()));
        BlockState blockstate1 = worldIn.m_8055_(blockpos1);
        BlockState blockstate2 = worldIn.m_8055_(blockpos2);
        return Math.max(Math.max(i, j), Math.max(blockstate1.m_60713_(Blocks.f_50088_) ? (Integer)blockstate1.m_61143_((Property)RedStoneWireBlock.f_55500_) : 0, blockstate2.m_60713_(Blocks.f_50088_) ? (Integer)blockstate2.m_61143_((Property)RedStoneWireBlock.f_55500_) : 0));
    }

    protected int getPowerOnSides(LevelReader worldIn, BlockPos pos, Direction direction) {
        Direction direction1 = direction.m_122427_();
        Direction direction2 = direction.m_122428_();
        return Math.max(this.getPowerOnSide(worldIn, pos.m_121945_(direction1), direction2), this.getPowerOnSide(worldIn, pos.m_121945_(direction2), direction1));
    }

    protected int getPowerOnSide(LevelReader worldIn, BlockPos pos, Direction side) {
        BlockState blockstate = worldIn.m_8055_(pos);
        if (this.isAlternateInput(blockstate)) {
            if (blockstate.m_60713_(Blocks.f_50330_)) {
                return 15;
            }
            return blockstate.m_60713_(Blocks.f_50088_) ? ((Integer)blockstate.m_61143_((Property)RedStoneWireBlock.f_55500_)).intValue() : worldIn.m_46852_(pos, side);
        }
        return 0;
    }

    protected boolean isAlternateInput(BlockState state) {
        return state.m_60803_();
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (this.shouldBePowered(worldIn, pos, state)) {
            worldIn.m_186460_(pos, (Block)this, 1);
        }
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(worldIn, pos, state, player);
        if (worldIn.m_5776_()) {
            return;
        }
        BlockEntity te = worldIn.m_7702_(pos);
        if (te == null) {
            return;
        }
        if (!(te instanceof IWireNode)) {
            return;
        }
        IWireNode cte = (IWireNode)te;
        cte.dropWires(worldIn, !player.m_7500_());
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext c) {
        BlockEntity te = c.m_43725_().m_7702_(c.m_8083_());
        if (te == null) {
            return super.onSneakWrenched(state, c);
        }
        if (!(te instanceof IWireNode)) {
            return super.onSneakWrenched(state, c);
        }
        IWireNode cte = (IWireNode)te;
        if (!c.m_43725_().m_5776_()) {
            cte.dropWires(c.m_43725_(), c.m_43723_(), !c.m_43723_().m_7500_());
        }
        return super.onSneakWrenched(state, c);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        if (pos == null || side == null || state == null || world == null) {
            return false;
        }
        return (Boolean)state.m_61143_((Property)VERTICAL) == false && side.m_122434_() != ((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122434_();
    }

    private BlockState fromRotation(BlockState state, Direction dir) {
        return (BlockState)state.m_61124_((Property)HORIZONTAL_FACING, (Comparable)dir);
    }

    public BlockState m_6843_(BlockState state, Rotation direction) {
        return this.fromRotation(state, direction.m_55954_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return this.m_6843_(state, direction);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return this.fromRotation(state, mirror.m_54848_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    public BlockState transform(BlockState state, StructureTransform transform) {
        NodeRotation rotation = NodeRotation.get(transform.rotationAxis, transform.rotation);
        if (transform.mirror != null) {
            state = this.m_6943_(state, transform.mirror);
        }
        if (transform.rotationAxis == Direction.Axis.Y) {
            state = this.m_6843_(state, transform.rotation);
        }
        return (BlockState)state.m_61124_(NodeRotation.ROTATION, (Comparable)((Object)rotation));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return CABlockEntities.REDSTONE_RELAY.create(pos, state);
    }
}

