/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.LongConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.task.ISingleLongValueTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public final class TaskType {
    public final ResourceLocation id;
    public final Provider provider;
    private final Supplier<Icon> icon;
    private Component displayName;
    private GuiProvider guiProvider;
    public int intId;

    @Nullable
    public static Task createTask(Quest quest, String id) {
        if (((String)id).isEmpty()) {
            id = "ftbquests:item";
        } else if (((String)id).indexOf(58) == -1) {
            id = "ftbquests:" + (String)id;
        }
        TaskType type = TaskTypes.TYPES.get(new ResourceLocation((String)id));
        if (type == null) {
            return null;
        }
        return type.provider.create(quest);
    }

    TaskType(ResourceLocation i, Provider p, Supplier<Icon> ic) {
        this.id = i;
        this.provider = p;
        this.icon = ic;
        this.displayName = null;
        this.guiProvider = new GuiProvider(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void openCreationGui(Runnable gui, Quest quest, Consumer<Task> callback) {
                Task task = TaskType.this.provider.create(quest);
                if (task instanceof ISingleLongValueTask) {
                    ISingleLongValueTask t = (ISingleLongValueTask)((Object)task);
                    LongConfig c = new LongConfig(t.getMinConfigValue(), t.getMaxConfigValue());
                    EditConfigFromStringScreen.open((ConfigFromString)c, (Object)t.getDefaultConfigValue(), (Object)t.getDefaultConfigValue(), accepted -> {
                        if (accepted) {
                            ((ISingleLongValueTask)((Object)task)).setValue((Long)c.value);
                            callback.accept(task);
                        }
                        gui.run();
                    });
                    return;
                }
                ConfigGroup group = new ConfigGroup("ftbquests");
                task.getConfig(task.createSubGroup(group));
                group.savedCallback = accepted -> {
                    if (accepted) {
                        callback.accept(task);
                    }
                    gui.run();
                };
                new EditConfigScreen(group).openGui();
            }
        };
    }

    public String getTypeForNBT() {
        return this.id.m_135827_().equals("ftbquests") ? this.id.m_135815_() : this.id.toString();
    }

    public TaskType setDisplayName(Component name) {
        this.displayName = name;
        return this;
    }

    public Component getDisplayName() {
        if (this.displayName == null) {
            this.displayName = Component.m_237115_((String)("ftbquests.task." + this.id.m_135827_() + "." + this.id.m_135815_()));
        }
        return this.displayName;
    }

    public Icon getIcon() {
        return this.icon.get();
    }

    public TaskType setGuiProvider(GuiProvider p) {
        this.guiProvider = p;
        return this;
    }

    public GuiProvider getGuiProvider() {
        return this.guiProvider;
    }

    @FunctionalInterface
    public static interface Provider {
        public Task create(Quest var1);
    }

    public static interface GuiProvider {
        @OnlyIn(value=Dist.CLIENT)
        public void openCreationGui(Runnable var1, Quest var2, Consumer<Task> var3);
    }
}

