/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.cloned;

import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSection;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.Level;

public class ClonedChunkSectionCache {
    private final Level world;
    private final ConcurrentLinkedQueue<ClonedChunkSection> inactivePool = new ConcurrentLinkedQueue();
    private final Long2ReferenceMap<ClonedChunkSection> byPosition = new Long2ReferenceOpenHashMap();

    public ClonedChunkSectionCache(Level world) {
        this.world = world;
    }

    public synchronized ClonedChunkSection acquire(int x, int y, int z) {
        long key = SectionPos.m_123209_((int)x, (int)y, (int)z);
        ClonedChunkSection section = (ClonedChunkSection)this.byPosition.get(key);
        if (section != null) {
            this.inactivePool.remove(section);
        } else {
            section = this.createSection(x, y, z);
        }
        section.acquireReference();
        return section;
    }

    private ClonedChunkSection createSection(int x, int y, int z) {
        ClonedChunkSection section;
        if (!this.inactivePool.isEmpty()) {
            section = (ClonedChunkSection)this.inactivePool.remove();
            this.byPosition.remove(section.getPosition().m_123252_());
        } else {
            section = this.allocate();
        }
        SectionPos pos = SectionPos.m_123173_((int)x, (int)y, (int)z);
        section.init(this.world, pos);
        this.byPosition.put(pos.m_123252_(), (Object)section);
        return section;
    }

    public synchronized void invalidate(int x, int y, int z) {
        this.byPosition.remove(SectionPos.m_123209_((int)x, (int)y, (int)z));
    }

    public void release(ClonedChunkSection section) {
        if (section.releaseReference()) {
            this.tryReclaim(section);
        }
    }

    private ClonedChunkSection allocate() {
        return new ClonedChunkSection(this);
    }

    private void tryReclaim(ClonedChunkSection section) {
        this.inactivePool.add(section);
    }
}

