/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.passes;

import it.unimi.dsi.fastutil.objects.Reference2IntArrayMap;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import net.minecraft.client.renderer.RenderType;

public class BlockRenderPassManager {
    private final Reference2IntArrayMap<RenderType> mappingsId = new Reference2IntArrayMap();

    public BlockRenderPassManager() {
        this.mappingsId.defaultReturnValue(-1);
    }

    public int getRenderPassId(RenderType layer) {
        int pass = this.mappingsId.getInt((Object)layer);
        if (pass < 0) {
            throw new NullPointerException("No render pass exists for layer: " + layer);
        }
        return pass;
    }

    private void addMapping(RenderType layer, BlockRenderPass type) {
        if (this.mappingsId.put((Object)layer, type.ordinal()) >= 0) {
            throw new IllegalArgumentException("Layer target already defined for " + layer);
        }
    }

    public static BlockRenderPassManager createDefaultMappings() {
        BlockRenderPassManager mapper = new BlockRenderPassManager();
        mapper.addMapping(RenderType.m_110451_(), BlockRenderPass.SOLID);
        mapper.addMapping(RenderType.m_110457_(), BlockRenderPass.CUTOUT_MIPPED);
        mapper.addMapping(RenderType.m_110463_(), BlockRenderPass.CUTOUT);
        mapper.addMapping(RenderType.m_110466_(), BlockRenderPass.TRANSLUCENT);
        mapper.addMapping(RenderType.m_110503_(), BlockRenderPass.TRIPWIRE);
        return mapper;
    }

    public BlockRenderPass getRenderPassForLayer(RenderType layer) {
        return this.getRenderPass(this.getRenderPassId(layer));
    }

    public BlockRenderPass getRenderPass(int i) {
        return BlockRenderPass.VALUES[i];
    }
}

