/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.control;

import cofh.core.network.packet.server.TransferControlPacket;
import cofh.core.util.control.ITransferControllableTile;
import cofh.lib.api.control.ITransferControllable;
import cofh.lib.util.Constants;
import cofh.lib.util.Utils;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class TransferControlModule
implements ITransferControllable {
    protected ITransferControllableTile tile;
    protected Supplier<Boolean> enabled;
    protected boolean enableAutoInput;
    protected boolean enableAutoOutput;

    public TransferControlModule(ITransferControllableTile tile) {
        this(tile, Constants.TRUE);
    }

    public TransferControlModule(ITransferControllableTile tile, Supplier<Boolean> enabled) {
        this.tile = tile;
        this.enabled = enabled;
    }

    public TransferControlModule setEnabled(Supplier<Boolean> enabled) {
        this.enabled = enabled;
        return this;
    }

    public void disable() {
        this.enableAutoInput = false;
        this.enableAutoOutput = false;
    }

    public void initControl(boolean input, boolean output) {
        if (this.hasTransferIn()) {
            this.enableAutoInput = input;
        }
        if (this.hasTransferOut()) {
            this.enableAutoOutput = output;
        }
    }

    public void readFromBuffer(FriendlyByteBuf buffer) {
        this.enableAutoInput = buffer.readBoolean();
        this.enableAutoOutput = buffer.readBoolean();
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.enableAutoInput);
        buffer.writeBoolean(this.enableAutoOutput);
    }

    public TransferControlModule read(CompoundTag nbt) {
        CompoundTag subTag = nbt.m_128469_("Xfer");
        if (!subTag.m_128456_()) {
            this.enableAutoInput = subTag.m_128471_("XferIn");
            this.enableAutoOutput = subTag.m_128471_("XferOut");
        }
        return this;
    }

    public CompoundTag write(CompoundTag nbt) {
        CompoundTag subTag = new CompoundTag();
        if (this.enabled.get().booleanValue()) {
            subTag.m_128379_("XferIn", this.enableAutoInput);
            subTag.m_128379_("XferOut", this.enableAutoOutput);
            nbt.m_128365_("Xfer", (Tag)subTag);
        }
        return nbt;
    }

    public TransferControlModule readSettings(CompoundTag nbt) {
        if (this.enabled.get().booleanValue()) {
            return this.read(nbt);
        }
        return this;
    }

    public CompoundTag writeSettings(CompoundTag nbt) {
        return this.write(nbt);
    }

    @Override
    public boolean hasTransferIn() {
        return this.enabled.get();
    }

    @Override
    public boolean hasTransferOut() {
        return this.enabled.get();
    }

    @Override
    public boolean getTransferIn() {
        return this.hasTransferIn() && this.enableAutoInput;
    }

    @Override
    public boolean getTransferOut() {
        return this.hasTransferOut() && this.enableAutoOutput;
    }

    @Override
    public void setControl(boolean input, boolean output) {
        boolean curInput = this.enableAutoInput;
        boolean curOutput = this.enableAutoOutput;
        if (this.hasTransferIn()) {
            this.enableAutoInput = input;
        }
        if (this.hasTransferOut()) {
            this.enableAutoOutput = output;
        }
        if (Utils.isClientWorld(this.tile.world())) {
            TransferControlPacket.sendToServer(this.tile);
            this.enableAutoInput = curInput;
            this.enableAutoOutput = curOutput;
        } else {
            this.tile.onControlUpdate();
        }
    }
}

