/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.fluid;

import cofh.core.CoFHCore;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.fluid.FluidCoFH;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class PotionFluid
extends FluidCoFH {
    private static PotionFluid INSTANCE;
    public static final RegistryObject<FluidType> TYPE;
    public static int DEFAULT_COLOR;

    public static PotionFluid create() {
        if (INSTANCE == null) {
            INSTANCE = new PotionFluid();
        }
        return INSTANCE;
    }

    protected PotionFluid() {
        super(CoFHCore.FLUIDS, "potion");
    }

    @Override
    protected ForgeFlowingFluid.Properties fluidProperties() {
        return new ForgeFlowingFluid.Properties(this.type(), (Supplier)this.stillFluid, (Supplier)this.flowingFluid);
    }

    @Override
    protected Supplier<FluidType> type() {
        return TYPE;
    }

    public static int getPotionColor(FluidStack stack) {
        CompoundTag tag = stack.getTag();
        if (tag != null && tag.m_128425_("CustomPotionColor", 99)) {
            return tag.m_128451_("CustomPotionColor");
        }
        return FluidHelper.getPotionFromFluidTag(stack.getTag()) == Potions.f_43598_ ? DEFAULT_COLOR : PotionUtils.m_43564_((Collection)PotionUtils.m_43566_((CompoundTag)stack.getTag()));
    }

    public static FluidStack getPotionAsFluid(int amount, Potion type, boolean hasCustom) {
        if (type == null) {
            return FluidStack.EMPTY;
        }
        if (type == Potions.f_43599_ && !hasCustom) {
            return new FluidStack((Fluid)Fluids.f_76193_, amount);
        }
        return PotionFluid.addPotionToFluidStack(new FluidStack((Fluid)PotionFluid.INSTANCE.stillFluid.get(), amount), type);
    }

    public static FluidStack getPotionAsFluid(int amount, Potion type) {
        return PotionFluid.getPotionAsFluid(amount, type, false);
    }

    public static FluidStack addPotionToFluidStack(FluidStack stack, Potion type) {
        ResourceLocation resourceLoc = ForgeRegistries.POTIONS.getKey((Object)type);
        if (resourceLoc == null) {
            return FluidStack.EMPTY;
        }
        stack.getOrCreateTag().m_128359_("Potion", resourceLoc.toString());
        return stack;
    }

    public static FluidStack setCustomEffects(FluidStack stack, Collection<MobEffectInstance> effects) {
        if (stack.isEmpty() || effects.isEmpty()) {
            return stack;
        }
        CompoundTag compoundtag = stack.getOrCreateTag();
        ListTag listtag = compoundtag.m_128437_("CustomPotionEffects", 9);
        for (MobEffectInstance mobeffectinstance : effects) {
            listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
        }
        compoundtag.m_128365_("CustomPotionEffects", (Tag)listtag);
        return stack;
    }

    public static Collection<MobEffectInstance> getCustomEffects(FluidStack stack) {
        if (stack.isEmpty() || !stack.hasTag()) {
            return Collections.emptyList();
        }
        return PotionUtils.m_43573_((CompoundTag)stack.getOrCreateTag());
    }

    public static FluidStack setCustomColor(FluidStack stack, int color) {
        stack.getOrCreateTag().m_128405_("CustomPotionColor", color);
        return stack;
    }

    public static ItemStack setCustomColor(ItemStack stack, int color) {
        stack.m_41784_().m_128405_("CustomPotionColor", color);
        return stack;
    }

    public static FluidStack getPotionFluidFromItem(int amount, ItemStack stack) {
        Item item = stack.m_41720_();
        if (item.equals(Items.f_42589_)) {
            List custom = PotionUtils.m_43571_((ItemStack)stack);
            FluidStack fluid = PotionFluid.setCustomEffects(PotionFluid.getPotionAsFluid(amount, PotionUtils.m_43579_((ItemStack)stack), !custom.isEmpty()), custom);
            int color = PotionUtils.m_43575_((ItemStack)stack);
            if (color != PotionUtils.m_43564_((Collection)PotionUtils.m_43547_((ItemStack)stack))) {
                PotionFluid.setCustomColor(fluid, color);
            }
            return fluid;
        }
        return FluidStack.EMPTY;
    }

    public static ItemStack getItemFromPotionFluid(FluidStack fluid) {
        ItemStack stack = PotionUtils.m_43552_((ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)FluidHelper.getPotionFromFluid(fluid)), PotionFluid.getCustomEffects(fluid));
        int color = PotionFluid.getPotionColor(fluid);
        if (color != PotionUtils.m_43575_((ItemStack)stack)) {
            PotionFluid.setCustomColor(stack, color);
        }
        return stack;
    }

    static {
        TYPE = CoFHCore.FLUID_TYPES.register("potion", () -> new FluidType(FluidType.Properties.create().density(1100).viscosity(1100).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11770_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11769_)){

            public Component getDescription(FluidStack stack) {
                Potion potion = PotionUtils.m_43577_((CompoundTag)stack.getTag());
                if (potion == Potions.f_43598_ || potion == Potions.f_43599_) {
                    return super.getDescription(stack);
                }
                return Component.m_237115_((String)potion.m_43492_(Items.f_42589_.m_5524_() + ".effect."));
            }

            public Rarity getRarity(FluidStack stack) {
                return FluidHelper.getPotionFromFluidTag(stack.getTag()).m_43488_().isEmpty() ? Rarity.COMMON : Rarity.UNCOMMON;
            }

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){
                    private static final ResourceLocation STILL = new ResourceLocation("cofh_core:block/fluids/potion_still");
                    private static final ResourceLocation FLOW = new ResourceLocation("cofh_core:block/fluids/potion_flow");

                    public int getTintColor(FluidStack stack) {
                        return 0xFF000000 | PotionFluid.getPotionColor(stack);
                    }

                    public ResourceLocation getStillTexture() {
                        return STILL;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return FLOW;
                    }
                });
            }
        });
        DEFAULT_COLOR = 0xF800F8;
    }
}

