/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element;

import cofh.core.CoFHCore;
import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementBase;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.util.Constants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public class ElementSlot
extends ElementBase {
    protected ResourceLocation underlayTexture;
    protected ResourceLocation overlayTexture;
    protected Supplier<Boolean> drawUnderlay = Constants.TRUE;
    protected Supplier<Boolean> drawOverlay = Constants.TRUE;

    public ElementSlot(IGuiAccess gui, int posX, int posY) {
        super(gui, posX, posY);
    }

    public final ElementSlot setUnderlayTexture(String texture) {
        return this.setUnderlayTexture(texture, Constants.TRUE);
    }

    public final ElementSlot setUnderlayTexture(String texture, Supplier<Boolean> draw) {
        if (texture == null || draw == null) {
            CoFHCore.LOG.warn("Attempted to assign a NULL underlay texture.");
            return this;
        }
        this.underlayTexture = new ResourceLocation(texture);
        this.drawUnderlay = draw;
        return this;
    }

    public final ElementSlot setOverlayTexture(String texture) {
        return this.setOverlayTexture(texture, Constants.TRUE);
    }

    public final ElementSlot setOverlayTexture(String texture, Supplier<Boolean> draw) {
        if (texture == null || draw == null) {
            CoFHCore.LOG.warn("Attempted to assign a NULL overlay texture.");
            return this;
        }
        this.overlayTexture = new ResourceLocation(texture);
        this.drawOverlay = draw;
        return this;
    }

    @Override
    public void drawBackground(PoseStack poseStack, int mouseX, int mouseY) {
        this.drawSlot(poseStack);
        this.drawUnderlayTexture(poseStack);
    }

    @Override
    public void drawForeground(PoseStack poseStack, int mouseX, int mouseY) {
        this.drawOverlayTexture(poseStack);
    }

    protected void drawSlot(PoseStack poseStack) {
        RenderHelper.setPosTexShader();
        RenderHelper.setShaderTexture0(this.texture);
        this.drawTexturedModalRect(poseStack, this.posX(), this.posY(), 0, 0, this.width, this.height);
    }

    protected void drawUnderlayTexture(PoseStack poseStack) {
        if (this.drawUnderlay.get().booleanValue() && this.underlayTexture != null) {
            RenderHelper.setPosTexShader();
            RenderHelper.setShaderTexture0(this.underlayTexture);
            this.drawTexturedModalRect(poseStack, this.posX(), this.posY(), 0, 0, this.width, this.height);
        }
    }

    protected void drawOverlayTexture(PoseStack poseStack) {
        if (this.drawOverlay.get().booleanValue() && this.overlayTexture != null) {
            RenderHelper.setPosTexShader();
            RenderHelper.setShaderTexture0(this.overlayTexture);
            this.drawTexturedModalRect(poseStack, this.posX(), this.posY(), 0, 0, this.width, this.height);
        }
    }
}

