/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.snbt;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.function.BooleanSupplier;

public class SNBTUtils {
    public static final BooleanSupplier ALWAYS_TRUE = () -> true;
    public static final char[] ESCAPE_CHARS = new char[128];
    public static final char[] REVERSE_ESCAPE_CHARS = new char[128];

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isSimpleCharacter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || SNBTUtils.isDigit(c) || c == '.' || c == '_' || c == '-' || c == '+' || c == '\u221e';
    }

    public static boolean isSimpleString(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (SNBTUtils.isSimpleCharacter(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int getNumberType(String s) {
        if (s.isEmpty()) {
            return 8;
        }
        char last = Character.toLowerCase(s.charAt(s.length() - 1));
        if (Character.isDigit(last) && Ints.tryParse((String)s) != null) {
            return 3;
        }
        String start = s.substring(0, s.length() - 1);
        if (last == 'b' && Ints.tryParse((String)start) != null) {
            return 1;
        }
        if (last == 's' && Ints.tryParse((String)start) != null) {
            return 2;
        }
        if (last == 'l' && Longs.tryParse((String)start) != null) {
            return 4;
        }
        if (last == 'f' && Floats.tryParse((String)start) != null) {
            return 5;
        }
        if (last == 'd' && Doubles.tryParse((String)start) != null) {
            return 6;
        }
        if (Floats.tryParse((String)s) != null) {
            return -6;
        }
        return 8;
    }

    @Deprecated(forRemoval=true)
    public static boolean isInt(String s, int off) {
        int len = s.length() - off;
        if (len <= 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (!(c == '-' ? i != 0 : !SNBTUtils.isDigit(c))) continue;
            return false;
        }
        return true;
    }

    @Deprecated(forRemoval=true)
    public static boolean isFloat(String s, int off) {
        int len = s.length() - off;
        if (len <= 0) {
            return false;
        }
        int p = 0;
        int e = 0;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '-') {
                if (i == 0) continue;
                return false;
            }
            if (c == '.') {
                if (i == 0 || i == len - 1) {
                    return false;
                }
                if (++p < 2) continue;
                return false;
            }
            if (c == 'E') {
                if (i == 0 || i == len - 1) {
                    return false;
                }
                if (++e < 2) continue;
                return false;
            }
            if (SNBTUtils.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static String handleEscape(String string) {
        return SNBTUtils.isSimpleString(string) ? string : SNBTUtils.quoteAndEscape(string);
    }

    public static String quoteAndEscape(String string) {
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 2);
        sb.append('\"');
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c < ESCAPE_CHARS.length && ESCAPE_CHARS[c] != '\u0000') {
                sb.append('\\');
                sb.append(ESCAPE_CHARS[c]);
                continue;
            }
            sb.append(c);
        }
        sb.append('\"');
        return sb.toString();
    }

    static {
        SNBTUtils.ESCAPE_CHARS[34] = 34;
        SNBTUtils.ESCAPE_CHARS[92] = 92;
        SNBTUtils.ESCAPE_CHARS[9] = 116;
        SNBTUtils.ESCAPE_CHARS[8] = 98;
        SNBTUtils.ESCAPE_CHARS[10] = 110;
        SNBTUtils.ESCAPE_CHARS[13] = 114;
        SNBTUtils.ESCAPE_CHARS[12] = 102;
        for (int i = 0; i < ESCAPE_CHARS.length; ++i) {
            if (ESCAPE_CHARS[i] == '\u0000') continue;
            SNBTUtils.REVERSE_ESCAPE_CHARS[SNBTUtils.ESCAPE_CHARS[i]] = (char)i;
        }
    }
}

