/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.datagen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModBlocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.registries.RegistryObject;

public class MGULootTables
extends LootTableProvider {
    public MGULootTables(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    @Nonnull
    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(Blocks::new, (Object)LootContextParamSets.f_81421_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationContext validationtracker) {
        map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)name, (LootTable)table));
    }

    private static class Blocks
    extends BlockLoot {
        private Blocks() {
        }

        protected void addTables() {
            this.m_124288_((Block)ModBlocks.ABSORPTION_HOPPER.getBlock());
            this.m_124288_(ModBlocks.DARK_OAK_STONE.getBlock());
            this.m_124288_(ModBlocks.DRAGON_MUFFLER.getBlock());
            this.m_124288_(ModBlocks.WITHER_MUFFLER.getBlock());
            this.m_124288_(ModBlocks.ENTITY_CONVEYOR.getBlock());
            this.m_124288_((Block)ModBlocks.FAN.getBlock());
            this.m_124288_((Block)ModBlocks.SAW.getBlock());
            this.m_124288_((Block)ModBlocks.SPIKES.getBlock());
            this.m_124288_((Block)ModBlocks.XP_TAP.getBlock());
            this.m_124288_(ModBlocks.ENDER_INHIBITOR_ON.getBlock());
            this.m_124147_(ModBlocks.ENDER_INHIBITOR_OFF.getBlock(), (ItemLike)ModBlocks.ENDER_INHIBITOR_ON.getItem());
            this.m_124288_(ModBlocks.TINTED_GLASS.getBlock());
            this.m_124175_(ModBlocks.DREADFUL_DIRT.getBlock(), block -> Blocks.m_124257_((Block)block, (ItemLike)Items.f_42329_));
            this.m_124175_(ModBlocks.DELIGHTFUL_DIRT.getBlock(), block -> Blocks.m_124257_((Block)block, (ItemLike)Items.f_42329_));
            this.m_124288_((Block)ModBlocks.SOLID_XP_BLOCK.getBlock());
            this.m_124288_(ModBlocks.ENTITY_SPAWNER.getBlock());
        }

        @Nonnull
        protected Iterable<Block> getKnownBlocks() {
            ImmutableSet ignoreList = ImmutableSet.of((Object)((Object)ModBlocks.TANK.getBlock()), (Object)((Object)ModBlocks.TANK_SINK.getBlock()), (Object)((Object)ModBlocks.JUMBO_TANK.getBlock()), (Object)((Object)ModBlocks.XPSOLIDIFIER.getBlock()), (Object)((Block)ModBlocks.FLUID_XP_BLOCK.get()));
            return ModBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get).filter(arg_0 -> Blocks.lambda$getKnownBlocks$2((Set)ignoreList, arg_0)).collect(Collectors.toList());
        }

        private static /* synthetic */ boolean lambda$getKnownBlocks$2(Set ignoreList, Block e) {
            return !ignoreList.contains(e);
        }
    }
}

