/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.misc;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;

public class TransmutationData {
    private Map<ItemStack, Double> itemstackData = new HashMap<ItemStack, Double>();

    public void onTransmuteItem(ItemStack beingTransmuted, ItemStack turnedInto) {
        double fromWeight = this.getWeight(beingTransmuted);
        double toWeight = this.getWeight(turnedInto);
        this.putWeight(beingTransmuted, fromWeight + TransmutationData.calculateAddWeight(beingTransmuted.m_41613_()));
        this.putWeight(turnedInto, toWeight + TransmutationData.calculateRemoveWeight(turnedInto.m_41613_()));
    }

    public double getWeight(ItemStack stack) {
        for (Map.Entry<ItemStack, Double> entry : this.itemstackData.entrySet()) {
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)entry.getKey())) continue;
            return entry.getValue();
        }
        return 0.0;
    }

    private static double calculateAddWeight(int count) {
        return Math.log(Math.pow(count, AMConfig.transmutingWeightAddStep));
    }

    private static double calculateRemoveWeight(int count) {
        return -Math.log(Math.pow(count, AMConfig.transmutingWeightRemoveStep));
    }

    public void putWeight(ItemStack stack, double newWeight) {
        ItemStack replace = stack;
        for (Map.Entry<ItemStack, Double> entry : this.itemstackData.entrySet()) {
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)entry.getKey())) continue;
            replace = entry.getKey();
            break;
        }
        this.itemstackData.put(replace, Math.max(newWeight, 0.0));
    }

    @Nullable
    public ItemStack getRandomItem(RandomSource random) {
        ItemStack result = null;
        double bestValue = Double.MAX_VALUE;
        for (Map.Entry<ItemStack, Double> entry : this.itemstackData.entrySet()) {
            double value;
            if (entry.getValue() <= 0.0 || !((value = -Math.log(random.m_188500_()) / entry.getValue()) < bestValue)) continue;
            bestValue = value;
            result = entry.getKey().m_41777_();
        }
        return result;
    }

    public CompoundTag saveAsNBT() {
        CompoundTag compound = new CompoundTag();
        ListTag listTag = new ListTag();
        for (Map.Entry<ItemStack, Double> entry : this.itemstackData.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("Item", (Tag)entry.getKey().m_41739_(new CompoundTag()));
            tag.m_128347_("Weight", entry.getValue().doubleValue());
            listTag.add((Object)tag);
        }
        compound.m_128365_("TransmutationData", (Tag)listTag);
        return compound;
    }

    public static TransmutationData fromNBT(CompoundTag compound) {
        TransmutationData data = new TransmutationData();
        if (compound.m_128441_("TransmutationData")) {
            ListTag listtag = compound.m_128437_("TransmutationData", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag innerTag = listtag.m_128728_(i);
                try {
                    ItemStack from = ItemStack.m_41712_((CompoundTag)innerTag.m_128469_("Item"));
                    if (from.m_41619_()) continue;
                    data.putWeight(from, innerTag.m_128459_("Weight"));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return data;
    }

    public double getTotalWeight() {
        double total = 0.0;
        for (Map.Entry<ItemStack, Double> entry : this.itemstackData.entrySet()) {
            total += entry.getValue().doubleValue();
        }
        return total;
    }
}

