/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamresourceful.resourcefulconfig.common.config.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.common.config.ResourcefulConfigEntry;
import earth.terrarium.ad_astra.AdAstra;
import earth.terrarium.ad_astra.client.screen.PlayerOverlayScreen;
import earth.terrarium.ad_astra.common.config.AdAstraConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public class OverlayConfigScreen
extends Screen {
    private final Screen parent;
    private List<Overlay> overlays;
    private double clickedX;
    private double clickedY;
    private double pivotX;
    private double pivotY;
    private boolean dragging;
    private Overlay selectdOverlay;

    public OverlayConfigScreen(Screen parent) {
        super((Component)Component.m_237119_());
        this.parent = parent;
        this.overlays = new ArrayList<Overlay>();
        this.overlays.add(new OxygenTankOverlay());
        this.overlays.add(new EnergyBarOverlay());
    }

    protected void m_7856_() {
        super.m_7856_();
        for (Overlay overlay : this.overlays) {
            overlay.load(this.f_96541_);
        }
        int buttonCount = 3;
        int buttonWidth = 80;
        int buttonHeight = 20;
        int buttonMargin = 5;
        int totalWidth = buttonCount * buttonWidth + (buttonCount - 1) * buttonMargin;
        int buttonOffset = buttonWidth + buttonMargin;
        int x = (this.f_96543_ - totalWidth) / 2;
        int y = this.f_96544_ - 27;
        this.m_142416_((GuiEventListener)new Button(x + buttonOffset * 0, y, buttonWidth, buttonHeight, (Component)Component.m_237115_((String)"gui.ad_astra.text.save"), button -> {
            for (Overlay overlay : this.overlays) {
                overlay.save(this.f_96541_);
            }
            AdAstra.CONFIGURATOR.saveConfig(AdAstraConfig.class);
            this.m_7379_();
        }));
        this.m_142416_((GuiEventListener)new Button(x + buttonOffset * 1, y, buttonWidth, buttonHeight, (Component)Component.m_237115_((String)"gui.ad_astra.text.reset"), button -> {
            for (Overlay overlay : this.overlays) {
                overlay.reset(this.f_96541_);
            }
        }));
        this.m_142416_((GuiEventListener)new Button(x + buttonOffset * 2, y, buttonWidth, buttonHeight, (Component)Component.m_237115_((String)"gui.ad_astra.text.back"), button -> this.m_7379_()));
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.getParent());
        for (Overlay overlay : this.overlays) {
            overlay.revert(this.f_96541_);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        this.m_7333_(poseStack);
        this.drag(mouseX, mouseY);
        for (Overlay overlay : this.overlays) {
            overlay.apply(this.f_96541_);
            overlay.render(poseStack, this.f_96541_);
        }
        super.m_6305_(poseStack, mouseX, mouseY, delta);
        int x = 10;
        int y = 10;
        GuiComponent.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.ad_astra.text.overlay_config1"), (int)x, (int)y, (int)0xFFFFFF);
        MutableComponent mutableComponent = Component.m_237115_((String)"gui.ad_astra.text.overlay_config2");
        Objects.requireNonNull(this.f_96547_);
        GuiComponent.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)mutableComponent, (int)x, (int)(y + 9), (int)0xFFFFFF);
    }

    private void drag(int mouseX, int mouseY) {
        Overlay overlay = this.selectdOverlay;
        if (overlay == null) {
            return;
        }
        if (!this.dragging) {
            int dragThreashold = 3;
            double movementX = (double)mouseX - this.clickedX;
            double movementY = (double)mouseY - this.clickedY;
            boolean bl = this.dragging = Math.abs(movementX) >= (double)dragThreashold || Math.abs(movementY) >= (double)dragThreashold;
        }
        if (!this.dragging) {
            return;
        }
        float scale = overlay.getScale();
        double unscaledMouseX = (float)mouseX / scale;
        double unscaledMouseY = (float)mouseY / scale;
        Rect2i renderRect = overlay.getUnscaledRenderRect(this.f_96541_);
        Vec2 prevPosition = overlay.getUnscaledPosition();
        double offsetX = (double)((float)renderRect.m_110085_() - prevPosition.f_82470_) + Mth.m_14139_((double)this.pivotX, (double)0.0, (double)renderRect.m_110090_());
        double offsetY = (double)((float)renderRect.m_110086_() - prevPosition.f_82471_) + Mth.m_14139_((double)this.pivotY, (double)0.0, (double)renderRect.m_110091_());
        Vec2 position = new Vec2((float)((int)(unscaledMouseX - offsetX)), (float)((int)(unscaledMouseY - offsetY)));
        overlay.setUnscaledPosition(position);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Overlay overlay = this.getOverlay(mouseX, mouseY);
        if (overlay != null) {
            this.select(overlay, mouseX, mouseY);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private Overlay getOverlay(double mouseX, double mouseY) {
        for (Overlay overlay : this.overlays) {
            float scale = overlay.getScale();
            double unscaledMouseX = mouseX / (double)scale;
            double unscaledMouseY = mouseY / (double)scale;
            Rect2i renderRect = overlay.getUnscaledRenderRect(this.f_96541_);
            if (!renderRect.m_110087_((int)unscaledMouseX, (int)unscaledMouseY)) continue;
            return overlay;
        }
        return null;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        Overlay overlay = this.getOverlay(mouseX, mouseY);
        if (overlay != null) {
            float scale = overlay.getScale();
            double prevUnscaledMouseX = mouseX / (double)scale;
            double prevUnscaledMouseY = mouseY / (double)scale;
            Rect2i prevRenderRect = overlay.getUnscaledRenderRect(this.f_96541_);
            Vec2 prevPosition = overlay.getUnscaledPosition();
            double pivotX = Mth.m_14112_((double)(prevUnscaledMouseX - (double)prevRenderRect.m_110085_()), (double)0.0, (double)prevRenderRect.m_110090_());
            double pivotY = Mth.m_14112_((double)(prevUnscaledMouseY - (double)prevRenderRect.m_110086_()), (double)0.0, (double)prevRenderRect.m_110091_());
            float factor = 1.1f;
            scale = delta > 0.0 ? (scale *= factor) : (scale /= factor);
            overlay.setScale(scale);
            double nextUnscaledMouseX = mouseX / (double)scale;
            double nextUnscaledMouseY = mouseY / (double)scale;
            Rect2i nextRenderRect = overlay.getUnscaledRenderRect(this.f_96541_);
            double errorX = (double)nextRenderRect.m_110085_() + Mth.m_14139_((double)pivotX, (double)0.0, (double)nextRenderRect.m_110090_()) - nextUnscaledMouseX;
            double errorY = (double)nextRenderRect.m_110086_() + Mth.m_14139_((double)pivotY, (double)0.0, (double)nextRenderRect.m_110091_()) - nextUnscaledMouseY;
            Vec2 position = new Vec2((float)((double)prevPosition.f_82470_ - errorX), (float)((double)prevPosition.f_82471_ - errorY));
            overlay.setUnscaledPosition(position);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.deselect();
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void select(Overlay overlay, double clickedX, double clickedY) {
        float scale = overlay.getScale();
        double unscaledClickedX = clickedX / (double)scale;
        double unscaledClickedY = clickedY / (double)scale;
        Rect2i renderRect = overlay.getUnscaledRenderRect(this.f_96541_);
        this.clickedX = clickedX;
        this.clickedY = clickedY;
        this.pivotX = Mth.m_14112_((double)(unscaledClickedX - (double)renderRect.m_110085_()), (double)0.0, (double)renderRect.m_110090_());
        this.pivotY = Mth.m_14112_((double)(unscaledClickedY - (double)renderRect.m_110086_()), (double)0.0, (double)renderRect.m_110091_());
        this.dragging = false;
        this.selectdOverlay = overlay;
    }

    private void deselect() {
        this.dragging = false;
        this.selectdOverlay = null;
    }

    public boolean m_7043_() {
        return this.getParent().m_7043_();
    }

    public Screen getParent() {
        return this.parent;
    }

    public class OxygenTankOverlay
    extends Overlay {
        @Override
        protected void onLoad(Minecraft minecraft) {
            this.setUnscaledPosition(AdAstraConfig.oxygenBarXOffset, AdAstraConfig.oxygenBarYOffset);
            this.setScale(AdAstraConfig.oxygenBarScale);
        }

        @Override
        public void apply(Minecraft minecraft) {
            Vec2 position = this.getUnscaledPosition();
            AdAstraConfig.oxygenBarXOffset = (int)position.f_82470_;
            AdAstraConfig.oxygenBarYOffset = (int)position.f_82471_;
            AdAstraConfig.oxygenBarScale = this.getScale();
        }

        @Override
        protected void onResetConfig(Minecraft minecraft) {
            ResourcefulConfig config = AdAstra.CONFIGURATOR.getConfig(AdAstraConfig.class);
            ((ResourcefulConfigEntry)config.getEntry("oxygenBarXOffset").get()).reset();
            ((ResourcefulConfigEntry)config.getEntry("oxygenBarYOffset").get()).reset();
            ((ResourcefulConfigEntry)config.getEntry("oxygenBarScale").get()).reset();
        }

        @Override
        public void render(PoseStack poseStack, Minecraft minecraft) {
            PlayerOverlayScreen.renderOxygenTank(poseStack, minecraft);
        }

        @Override
        public Rect2i getUnscaledRenderRect(Minecraft minecraft) {
            return PlayerOverlayScreen.getOxygenTankUnscaledRect(minecraft);
        }
    }

    public class EnergyBarOverlay
    extends Overlay {
        @Override
        protected void onLoad(Minecraft minecraft) {
            int screenWidth = minecraft.m_91268_().m_85445_();
            this.setUnscaledPosition(screenWidth - AdAstraConfig.energyBarXOffset, AdAstraConfig.energyBarYOffset);
            this.setScale(AdAstraConfig.energyBarScale);
        }

        @Override
        public void apply(Minecraft minecraft) {
            int screenWidth = minecraft.m_91268_().m_85445_();
            Vec2 position = this.getUnscaledPosition();
            AdAstraConfig.energyBarXOffset = (int)((float)screenWidth - position.f_82470_);
            AdAstraConfig.energyBarYOffset = (int)position.f_82471_;
            AdAstraConfig.energyBarScale = this.getScale();
        }

        @Override
        protected void onResetConfig(Minecraft minecraft) {
            ResourcefulConfig config = AdAstra.CONFIGURATOR.getConfig(AdAstraConfig.class);
            ((ResourcefulConfigEntry)config.getEntry("energyBarXOffset").get()).reset();
            ((ResourcefulConfigEntry)config.getEntry("energyBarYOffset").get()).reset();
            ((ResourcefulConfigEntry)config.getEntry("energyBarScale").get()).reset();
        }

        @Override
        public void render(PoseStack poseStack, Minecraft minecraft) {
            PlayerOverlayScreen.renderEnergyBar(poseStack, minecraft);
        }

        @Override
        public Rect2i getUnscaledRenderRect(Minecraft minecraft) {
            return PlayerOverlayScreen.getEnergyBarUnscaledRect(minecraft);
        }
    }

    public abstract class Overlay {
        private Vec2 unscaledPositionBackup;
        private Vec2 unscaledPosition = new Vec2(0.0f, 0.0f);
        private float scaleBackup;
        private float scale = 0.0f;

        public void load(Minecraft minecraft) {
            this.onLoad(minecraft);
            this.backup();
        }

        public void revert(Minecraft minecraft) {
            this.restore();
            this.apply(minecraft);
        }

        public void reset(Minecraft minecraft) {
            this.onResetConfig(minecraft);
            this.onLoad(minecraft);
        }

        public void save(Minecraft minecraft) {
            this.apply(minecraft);
            this.backup();
        }

        protected void backup() {
            this.unscaledPositionBackup = this.unscaledPosition;
            this.scaleBackup = this.scale;
        }

        protected void restore() {
            this.unscaledPosition = this.unscaledPositionBackup;
            this.scale = this.scaleBackup;
        }

        protected abstract void onLoad(Minecraft var1);

        protected abstract void onResetConfig(Minecraft var1);

        public abstract void apply(Minecraft var1);

        public abstract void render(PoseStack var1, Minecraft var2);

        public abstract Rect2i getUnscaledRenderRect(Minecraft var1);

        public Vec2 getUnscaledPosition() {
            return this.unscaledPosition;
        }

        public void setUnscaledPosition(Vec2 position) {
            this.setUnscaledPosition(position.f_82470_, position.f_82471_);
        }

        public void setUnscaledPosition(float x, float y) {
            this.unscaledPosition = new Vec2(x, y);
        }

        public float getScale() {
            return this.scale;
        }

        public void setScale(float scale) {
            this.scale = Math.max(scale, 0.0f);
        }
    }
}

