/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.minimap.render.radar.ModelPartRenderDetectionInfo;
import xaero.common.minimap.render.radar.ModelRenderDetectionElement;
import xaero.common.misc.Misc;

public class EntityIconModelPartsRenderer {
    public Method ageableModelHeadPartsMethod;
    public Method ageableModelBodyPartsMethod;
    public Method segmentedModelPartsMethod;
    private Field cubeListField;
    private Field childModelsField;
    private VertexConsumerWrapper vertexConsumerWrapper;
    private boolean testedRenderEngineWrapperCompatibility;
    private boolean renderEngineIsWrapperCompatible;
    private IXaeroMinimap modMain;

    public EntityIconModelPartsRenderer(IXaeroMinimap modMain) {
        this.modMain = modMain;
        this.ageableModelHeadPartsMethod = Misc.getMethodReflection(AgeableListModel.class, "m_5607_", new Class[0]);
        this.ageableModelBodyPartsMethod = Misc.getMethodReflection(AgeableListModel.class, "m_5608_", new Class[0]);
        this.segmentedModelPartsMethod = Misc.getMethodReflection(ListModel.class, "m_6195_", new Class[0]);
        this.cubeListField = Misc.getFieldReflection(ModelPart.class, "f_104212_");
        this.childModelsField = Misc.getFieldReflection(ModelPart.class, "f_104213_");
        this.vertexConsumerWrapper = new VertexConsumerWrapper();
    }

    private List<ModelPart.Cube> getCubeList(ModelPart modelRenderer) {
        return (List)Misc.getReflectFieldValue(modelRenderer, this.cubeListField);
    }

    public Map<String, ModelPart> getChildModels(ModelPart modelRenderer) {
        return (Map)Misc.getReflectFieldValue(modelRenderer, this.childModelsField);
    }

    public boolean hasDirectCubes(ModelPart mr) {
        List<ModelPart.Cube> mrCubeList = this.getCubeList(mr);
        return mrCubeList != null && !mrCubeList.isEmpty();
    }

    public boolean hasCubes(ModelPart mr) {
        if (this.hasDirectCubes(mr)) {
            return true;
        }
        Map<String, ModelPart> mrChildren = this.getChildModels(mr);
        for (ModelPart child : mrChildren.values()) {
            if (!this.hasCubes(child)) continue;
            return true;
        }
        return false;
    }

    public void renderPart(PoseStack matrixStack, VertexConsumer vertexBuilder, ModelPart mr, ArrayList<ModelPart> renderedModels, ModelPart mainModelPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        if (mr == null) {
            return;
        }
        if (renderedModels.contains(mr)) {
            return;
        }
        ModelPartRenderDetectionInfo renderInfo = mrde.getModelPartRenderInfo(mr);
        if (renderInfo == null) {
            return;
        }
        if (!this.hasCubes(mr)) {
            return;
        }
        boolean showModelBU = mr.f_104207_;
        boolean skipDrawBU = mr.f_233556_;
        if (!this.testedRenderEngineWrapperCompatibility) {
            boolean normalWorks;
            block17: {
                normalWorks = false;
                try {
                    PoseStack testMatrix = new PoseStack();
                    testMatrix.m_85837_(0.0, 0.0, -2500.0);
                    VertexConsumer actualVertexConsumer = this.modMain.getInterfaceRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers().m_6299_(CustomRenderTypes.entityIconRenderType(mrde.renderTexture, mrde.layerPhases));
                    mr.m_104306_(testMatrix, actualVertexConsumer, 0xF000F0, OverlayTexture.f_118083_, renderInfo.red, renderInfo.green, renderInfo.blue, renderInfo.alpha);
                    normalWorks = true;
                    testMatrix = new PoseStack();
                    testMatrix.m_85837_(0.0, 0.0, -2500.0);
                    this.vertexConsumerWrapper.prepareDetection(actualVertexConsumer, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                    mr.f_104207_ = true;
                    mr.f_233556_ = false;
                    mr.m_104306_(testMatrix, (VertexConsumer)this.vertexConsumerWrapper, 0xF000F0, OverlayTexture.f_118083_, renderInfo.red, renderInfo.green, renderInfo.blue, renderInfo.alpha);
                    this.renderEngineIsWrapperCompatible = this.vertexConsumerWrapper.detectedVertex;
                    if (!this.renderEngineIsWrapperCompatible) {
                        throw new Exception("can't detect vertices");
                    }
                }
                catch (Throwable t) {
                    if (!normalWorks) break block17;
                    MinimapLogs.LOGGER.warn("Render engine used for entities is not fully compatible with the minimap entity icons. Using fallback. " + t.getMessage());
                }
            }
            if (normalWorks) {
                this.testedRenderEngineWrapperCompatibility = true;
            }
        }
        float centerPointX = mainModelPart.f_104200_;
        float centerPointY = mainModelPart.f_104201_;
        float centerPointZ = mainModelPart.f_104202_;
        List<ModelPart.Cube> mainCubeList = this.getCubeList(mainModelPart);
        if (mainCubeList != null && !mainCubeList.isEmpty()) {
            float biggestSize = 0.0f;
            ModelPart.Cube biggestCuboid = null;
            for (ModelPart.Cube cuboid : mainCubeList) {
                float size = Math.abs((cuboid.f_104338_ - cuboid.f_104335_) * (cuboid.f_104339_ - cuboid.f_104336_) * (cuboid.f_104340_ - cuboid.f_104337_));
                if (!(size >= biggestSize)) continue;
                biggestCuboid = cuboid;
                biggestSize = size;
            }
            centerPointY += (biggestCuboid.f_104339_ + biggestCuboid.f_104336_) / 2.0f;
            centerPointZ += (biggestCuboid.f_104340_ + biggestCuboid.f_104337_) / 2.0f;
        }
        float xRotBU = 0.0f;
        float yRotBU = 0.0f;
        float zRotBU = 0.0f;
        if (zeroRotation) {
            xRotBU = mr.f_104203_;
            yRotBU = mr.f_104204_;
            zRotBU = mr.f_104205_;
            PartPose initPose = mr.m_233566_();
            mr.m_171327_(initPose.f_171408_, initPose.f_171409_, initPose.f_171410_);
        }
        mr.f_104207_ = true;
        mr.f_233556_ = false;
        float xBU = mr.f_104200_;
        float yBU = mr.f_104201_;
        float zBU = mr.f_104202_;
        mr.m_104227_(mr.f_104200_ - centerPointX, mr.f_104201_ - centerPointY, mr.f_104202_ - centerPointZ);
        try {
            VertexConsumer vertexConsumer = !this.renderEngineIsWrapperCompatible ? vertexBuilder : this.vertexConsumerWrapper.prepareDetection(vertexBuilder, 3.0, 61.0, 3.0, 61.0, -497.0, -2.0);
            mr.m_104306_(matrixStack, vertexConsumer, 0xF000F0, OverlayTexture.f_118083_, renderInfo.red, renderInfo.green, renderInfo.blue, renderInfo.alpha);
            if ((!this.renderEngineIsWrapperCompatible || this.vertexConsumerWrapper.hasDetectedVertex()) && renderInfo.alpha > 0.0f) {
                renderedModels.add(mr);
            }
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.info("Exception when rendering entity part. " + mr + " " + t.getMessage());
        }
        mr.m_104227_(xBU, yBU, zBU);
        while (GL11.glGetError() != 0) {
        }
        if (zeroRotation) {
            mr.m_171327_(xRotBU, yRotBU, zRotBU);
        }
        mr.f_104207_ = showModelBU;
        mr.f_233556_ = skipDrawBU;
    }

    public ModelPart renderDeclaredMethod(PoseStack matrixStack, VertexConsumer vertexBuilder, Method m, EntityModel entityModel, ArrayList<ModelPart> renderedModels, ModelPart mainPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        Iterable<ModelPart> renderers = this.handleDeclaredMethod(m, entityModel);
        return this.renderPartsIterable(renderers, matrixStack, vertexBuilder, renderedModels, mainPart, zeroRotation, mrde);
    }

    public Iterable<ModelPart> handleDeclaredMethod(Method m, EntityModel entityModel) {
        if (m != null) {
            return (Iterable)Misc.getReflectMethodValue(entityModel, m, new Object[0]);
        }
        return null;
    }

    public ModelPart renderPartsIterable(Iterable<ModelPart> parts, PoseStack matrixStack, VertexConsumer vertexBuilder, ArrayList<ModelPart> renderedModels, ModelPart mainPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        if (parts == null) {
            return mainPart;
        }
        Iterator<ModelPart> partsIterator = parts.iterator();
        if (partsIterator.hasNext()) {
            if (mainPart == null) {
                mainPart = partsIterator.next();
                this.renderPart(matrixStack, vertexBuilder, mainPart, renderedModels, mainPart, zeroRotation, mrde);
            }
            while (partsIterator.hasNext()) {
                this.renderPart(matrixStack, vertexBuilder, partsIterator.next(), renderedModels, mainPart, zeroRotation, mrde);
            }
        }
        return mainPart;
    }

    public static class VertexConsumerWrapper
    implements VertexConsumer {
        private VertexConsumer consumer;
        private boolean detectedVertex;
        private double detectionMinX;
        private double detectionMaxX;
        private double detectionMinY;
        private double detectionMaxY;
        private double detectionMinZ;
        private double detectionMaxZ;

        public VertexConsumerWrapper prepareDetection(VertexConsumer consumer, double detectionMinX, double detectionMaxX, double detectionMinY, double detectionMaxY, double detectionMinZ, double detectionMaxZ) {
            this.consumer = consumer;
            this.detectionMinX = detectionMinX;
            this.detectionMaxX = detectionMaxX;
            this.detectionMinY = detectionMinY;
            this.detectionMaxY = detectionMaxY;
            this.detectionMinZ = detectionMinZ;
            this.detectionMaxZ = detectionMaxZ;
            this.detectedVertex = false;
            return this;
        }

        public VertexConsumer m_5483_(double d, double e, double f) {
            if (d >= this.detectionMinX && d <= this.detectionMaxX && e >= this.detectionMinY && e <= this.detectionMaxY && f >= this.detectionMinZ && f <= this.detectionMaxZ) {
                this.detectedVertex = true;
            }
            return this.consumer.m_5483_(d, e, f);
        }

        public VertexConsumer m_6122_(int i, int j, int k, int l) {
            return this.consumer.m_6122_(i, j, k, l);
        }

        public VertexConsumer m_7421_(float f, float g) {
            return this.consumer.m_7421_(f, g);
        }

        public VertexConsumer m_7122_(int i, int j) {
            return this.consumer.m_7122_(i, j);
        }

        public VertexConsumer m_7120_(int i, int j) {
            return this.consumer.m_7120_(i, j);
        }

        public VertexConsumer m_5601_(float f, float g, float h) {
            return this.consumer.m_5601_(f, g, h);
        }

        public void m_5752_() {
            this.consumer.m_5752_();
        }

        public boolean hasDetectedVertex() {
            return this.detectedVertex;
        }

        public void m_7404_(int i, int j, int k, int l) {
            this.consumer.m_7404_(i, j, k, l);
        }

        public void m_141991_() {
            this.consumer.m_141991_();
        }
    }
}

