/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.ars_nouveau.geckolib3.util.json;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.ChainedJsonException;
import software.bernie.ars_nouveau.geckolib3.core.builder.Animation;
import software.bernie.ars_nouveau.geckolib3.core.builder.ILoopType;
import software.bernie.ars_nouveau.geckolib3.core.keyframe.BoneAnimation;
import software.bernie.ars_nouveau.geckolib3.core.keyframe.EventKeyFrame;
import software.bernie.ars_nouveau.geckolib3.core.keyframe.ParticleEventKeyFrame;
import software.bernie.ars_nouveau.geckolib3.core.keyframe.VectorKeyFrameList;
import software.bernie.ars_nouveau.geckolib3.core.molang.MolangParser;
import software.bernie.ars_nouveau.geckolib3.util.AnimationUtils;
import software.bernie.ars_nouveau.geckolib3.util.json.JsonKeyFrameUtils;
import software.bernie.ars_nouveau.shadowed.eliotlash.mclib.math.IValue;

public class JsonAnimationUtils {
    private static Gson GSON = null;

    public static Set<Map.Entry<String, JsonElement>> getAnimations(JsonObject json) {
        return json.getAsJsonObject("animations").entrySet();
    }

    public static List<Map.Entry<String, JsonElement>> getBones(JsonObject json) {
        JsonObject bones = json.getAsJsonObject("bones");
        return bones == null ? List.of() : new ArrayList(bones.entrySet());
    }

    public static Set<Map.Entry<String, JsonElement>> getRotationKeyFrames(JsonObject json) {
        JsonElement rotationObject = json.get("rotation");
        if (rotationObject.isJsonArray()) {
            return ImmutableSet.of(new AbstractMap.SimpleEntry<String, JsonArray>("0", rotationObject.getAsJsonArray()));
        }
        if (rotationObject.isJsonPrimitive()) {
            JsonPrimitive primitive = rotationObject.getAsJsonPrimitive();
            JsonElement jsonElement = JsonAnimationUtils.getGson().toJsonTree(Arrays.asList(primitive, primitive, primitive));
            return ImmutableSet.of(new AbstractMap.SimpleEntry<String, JsonElement>("0", jsonElement));
        }
        return rotationObject.getAsJsonObject().entrySet();
    }

    public static Set<Map.Entry<String, JsonElement>> getPositionKeyFrames(JsonObject json) {
        JsonElement positionObject = json.get("position");
        if (positionObject.isJsonArray()) {
            return ImmutableSet.of(new AbstractMap.SimpleEntry<String, JsonArray>("0", positionObject.getAsJsonArray()));
        }
        if (positionObject.isJsonPrimitive()) {
            JsonPrimitive primitive = positionObject.getAsJsonPrimitive();
            JsonElement jsonElement = JsonAnimationUtils.getGson().toJsonTree(Arrays.asList(primitive, primitive, primitive));
            return ImmutableSet.of(new AbstractMap.SimpleEntry<String, JsonElement>("0", jsonElement));
        }
        return positionObject.getAsJsonObject().entrySet();
    }

    public static Set<Map.Entry<String, JsonElement>> getScaleKeyFrames(JsonObject json) {
        JsonElement scaleObject = json.get("scale");
        if (scaleObject.isJsonArray()) {
            return ImmutableSet.of(new AbstractMap.SimpleEntry<String, JsonArray>("0", scaleObject.getAsJsonArray()));
        }
        if (scaleObject.isJsonPrimitive()) {
            JsonPrimitive primitive = scaleObject.getAsJsonPrimitive();
            JsonElement jsonElement = JsonAnimationUtils.getGson().toJsonTree(Arrays.asList(primitive, primitive, primitive));
            return ImmutableSet.of(new AbstractMap.SimpleEntry<String, JsonElement>("0", jsonElement));
        }
        return scaleObject.getAsJsonObject().entrySet();
    }

    public static List<Map.Entry<String, JsonElement>> getSoundEffectFrames(JsonObject json) {
        JsonObject soundEffects = json.getAsJsonObject("sound_effects");
        return soundEffects == null ? List.of() : new ObjectArrayList((Collection)soundEffects.entrySet());
    }

    public static List<Map.Entry<String, JsonElement>> getParticleEffectFrames(JsonObject json) {
        JsonObject particleEffects = json.getAsJsonObject("particle_effects");
        return particleEffects == null ? List.of() : new ObjectArrayList((Collection)particleEffects.entrySet());
    }

    public static List<Map.Entry<String, JsonElement>> getCustomInstructionKeyFrames(JsonObject json) {
        JsonObject customInstructions = json.getAsJsonObject("timeline");
        return customInstructions == null ? List.of() : new ArrayList(customInstructions.entrySet());
    }

    private static JsonElement getObjectByKey(Set<Map.Entry<String, JsonElement>> json, String key) throws ChainedJsonException {
        for (Map.Entry<String, JsonElement> entry : json) {
            if (!entry.getKey().equals(key)) continue;
            return entry.getValue();
        }
        throw new ChainedJsonException("Could not find key: " + key);
    }

    public static Map.Entry<String, JsonElement> getAnimation(JsonObject animationFile, String animationName) throws ChainedJsonException {
        return new AbstractMap.SimpleEntry<String, JsonElement>(animationName, JsonAnimationUtils.getObjectByKey(JsonAnimationUtils.getAnimations(animationFile), animationName));
    }

    public static Set<Map.Entry<String, JsonElement>> getObjectListAsArray(JsonObject json) {
        return json.entrySet();
    }

    public static Animation deserializeJsonToAnimation(Map.Entry<String, JsonElement> element, MolangParser parser) throws ClassCastException, IllegalStateException {
        Animation animation = new Animation();
        JsonObject animationJsonObject = element.getValue().getAsJsonObject();
        animation.animationName = element.getKey();
        JsonElement animationLength = animationJsonObject.get("animation_length");
        animation.animationLength = animationLength == null ? -1.0 : AnimationUtils.convertSecondsToTicks(animationLength.getAsDouble());
        animation.boneAnimations = new ObjectArrayList();
        animation.loop = ILoopType.fromJson(animationJsonObject.get("loop"));
        for (Map.Entry<String, JsonElement> keyFrame : JsonAnimationUtils.getSoundEffectFrames(animationJsonObject)) {
            animation.soundKeyFrames.add(new EventKeyFrame<String>(Double.parseDouble(keyFrame.getKey()) * 20.0, keyFrame.getValue().getAsJsonObject().get("effect").getAsString()));
        }
        for (Map.Entry<String, JsonElement> keyFrame : JsonAnimationUtils.getParticleEffectFrames(animationJsonObject)) {
            JsonObject object = keyFrame.getValue().getAsJsonObject();
            JsonElement effect = object.get("effect");
            JsonElement locator = object.get("locator");
            JsonElement pre_effect_script = object.get("pre_effect_script");
            animation.particleKeyFrames.add(new ParticleEventKeyFrame(Double.parseDouble(keyFrame.getKey()) * 20.0, effect == null ? "" : effect.getAsString(), locator == null ? "" : locator.getAsString(), pre_effect_script == null ? "" : pre_effect_script.getAsString()));
        }
        for (Map.Entry<String, JsonElement> keyFrame : JsonAnimationUtils.getCustomInstructionKeyFrames(animationJsonObject)) {
            animation.customInstructionKeyframes.add(new EventKeyFrame<String>(Double.parseDouble(keyFrame.getKey()) * 20.0, keyFrame.getValue() instanceof JsonArray ? JsonAnimationUtils.convertJsonArrayToList(keyFrame.getValue().getAsJsonArray()).toString() : keyFrame.getValue().getAsString()));
        }
        for (Map.Entry<String, JsonElement> bone : JsonAnimationUtils.getBones(animationJsonObject)) {
            BoneAnimation boneAnimation = new BoneAnimation(bone.getKey());
            JsonObject boneJsonObj = bone.getValue().getAsJsonObject();
            try {
                boneAnimation.scaleKeyFrames = JsonKeyFrameUtils.convertJsonToKeyFrames((List<Map.Entry<String, JsonElement>>)new ObjectArrayList(JsonAnimationUtils.getScaleKeyFrames(boneJsonObj)), parser);
            }
            catch (Exception e) {
                boneAnimation.scaleKeyFrames = new VectorKeyFrameList();
            }
            try {
                boneAnimation.positionKeyFrames = JsonKeyFrameUtils.convertJsonToKeyFrames((List<Map.Entry<String, JsonElement>>)new ObjectArrayList(JsonAnimationUtils.getPositionKeyFrames(boneJsonObj)), parser);
            }
            catch (Exception e) {
                boneAnimation.positionKeyFrames = new VectorKeyFrameList();
            }
            try {
                boneAnimation.rotationKeyFrames = JsonKeyFrameUtils.convertJsonToRotationKeyFrames((List<Map.Entry<String, JsonElement>>)new ObjectArrayList(JsonAnimationUtils.getRotationKeyFrames(boneJsonObj)), parser);
            }
            catch (Exception e) {
                boneAnimation.rotationKeyFrames = new VectorKeyFrameList();
            }
            animation.boneAnimations.add(boneAnimation);
        }
        if (animation.animationLength == -1.0) {
            animation.animationLength = JsonAnimationUtils.calculateLength(animation.boneAnimations);
        }
        return animation;
    }

    private static double calculateLength(List<BoneAnimation> boneAnimations) {
        double longestLength = 0.0;
        for (BoneAnimation animation : boneAnimations) {
            double xKeyframeTime = animation.rotationKeyFrames.getLastKeyframeTime();
            double yKeyframeTime = animation.positionKeyFrames.getLastKeyframeTime();
            double zKeyframeTime = animation.scaleKeyFrames.getLastKeyframeTime();
            longestLength = JsonAnimationUtils.maxAll(longestLength, xKeyframeTime, yKeyframeTime, zKeyframeTime);
        }
        return longestLength == 0.0 ? Double.MAX_VALUE : longestLength;
    }

    static List<IValue> convertJsonArrayToList(JsonArray array) {
        return (List)JsonAnimationUtils.getGson().fromJson((JsonElement)array, ArrayList.class);
    }

    private static Gson getGson() {
        if (GSON == null) {
            GSON = new Gson();
        }
        return GSON;
    }

    public static double maxAll(double ... values) {
        double max = 0.0;
        for (double value : values) {
            max = Math.max(value, max);
        }
        return max;
    }
}

