/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.ars_nouveau.geckolib3.core.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Locale;

public interface ILoopType {
    public boolean isRepeatingAfterEnd();

    public static ILoopType fromJson(JsonElement json) {
        if (json == null || !json.isJsonPrimitive()) {
            return EDefaultLoopTypes.PLAY_ONCE;
        }
        JsonPrimitive primitive = json.getAsJsonPrimitive();
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean() ? EDefaultLoopTypes.LOOP : EDefaultLoopTypes.PLAY_ONCE;
        }
        if (primitive.isString()) {
            String string = primitive.getAsString();
            if (string.equalsIgnoreCase("false")) {
                return EDefaultLoopTypes.PLAY_ONCE;
            }
            if (string.equalsIgnoreCase("true")) {
                return EDefaultLoopTypes.LOOP;
            }
            try {
                return EDefaultLoopTypes.valueOf(string.toUpperCase(Locale.ROOT));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return EDefaultLoopTypes.PLAY_ONCE;
    }

    public static enum EDefaultLoopTypes implements ILoopType
    {
        LOOP(true),
        PLAY_ONCE,
        HOLD_ON_LAST_FRAME;

        private final boolean looping;

        private EDefaultLoopTypes(boolean looping) {
            this.looping = looping;
        }

        private EDefaultLoopTypes() {
            this(false);
        }

        @Override
        public boolean isRepeatingAfterEnd() {
            return this.looping;
        }
    }
}

