/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.render.particle.instance;

import com.mojang.blaze3d.vertex.VertexConsumer;
import gg.moonflower.molangcompiler.api.MolangExpression;
import gg.moonflower.molangcompiler.api.bridge.MolangVariableProvider;
import gg.moonflower.pinwheel.api.particle.component.ParticleComponent;
import gg.moonflower.pinwheel.api.particle.render.ParticleRenderProperties;
import gg.moonflower.pollen.api.registry.particle.v1.BedrockParticleComponentFactory;
import gg.moonflower.pollen.api.render.particle.v1.BedrockParticle;
import gg.moonflower.pollen.api.render.particle.v1.BedrockParticleEmitter;
import gg.moonflower.pollen.api.render.particle.v1.component.BedrockParticleComponent;
import gg.moonflower.pollen.api.render.particle.v1.listener.BedrockParticleEmitterListener;
import gg.moonflower.pollen.impl.particle.BedrockParticleOption;
import gg.moonflower.pollen.impl.render.particle.instance.BedrockParticleImpl;
import gg.moonflower.pollen.impl.render.particle.instance.BedrockParticleInstanceImpl;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class BedrockParticleEmitterImpl
extends BedrockParticleImpl
implements BedrockParticleEmitter {
    @Nullable
    private final Entity entity;
    private final Set<BedrockParticleEmitterListener> listeners;
    private final Set<BedrockParticle> particles;

    public BedrockParticleEmitterImpl(@Nullable Entity entity, ClientLevel level, double x, double y, double z, ResourceLocation name) {
        super(level, x, y, z, name);
        this.entity = entity;
        this.listeners = new HashSet<BedrockParticleEmitterListener>();
        this.particles = new HashSet<BedrockParticle>();
        this.addComponents();
        this.getEnvironment().edit().setVariable("entity_scale", MolangExpression.of((float)1.0f)).setVariables((MolangVariableProvider)this);
    }

    @Override
    @Nullable
    protected BedrockParticleComponent addComponent(BedrockParticleComponentFactory<?> type, ParticleComponent data) {
        BedrockParticleComponent component = super.addComponent(type, data);
        if (component instanceof BedrockParticleEmitterListener) {
            BedrockParticleEmitterListener listener = (BedrockParticleEmitterListener)((Object)component);
            this.addEmitterListener(listener);
        }
        return component;
    }

    @Override
    public void addEmitterListener(BedrockParticleEmitterListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeEmitterListener(BedrockParticleEmitterListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        this.renderAge.setValue((float)this.age / 20.0f);
        this.particles.removeIf(BedrockParticle::isExpired);
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float f) {
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107434_;
    }

    @Override
    public void emitParticles(int count) {
        this.listeners.forEach(listener -> listener.onEmitParticles(this, count));
    }

    @Override
    public void restart() {
        this.age = 0;
        this.lifetime.setValue(0.0f);
        this.random1.setValue(this.random.nextFloat());
        this.random2.setValue(this.random.nextFloat());
        this.random3.setValue(this.random.nextFloat());
        this.random4.setValue(this.random.nextFloat());
        this.listeners.forEach(listener -> listener.onLoop(this));
    }

    @Override
    public BedrockParticle newParticle() {
        return new BedrockParticleInstanceImpl(this, this.f_107208_, this.f_107212_, this.f_107213_, this.f_107214_);
    }

    @Override
    public void summonParticle(BedrockParticle particle, double x, double y, double z) {
        if (!(particle instanceof Particle)) {
            throw new UnsupportedOperationException(particle.getName() + " must extend net.minecraft.client.particle.Particle");
        }
        Particle p = (Particle)particle;
        particle.setPosition(this.f_107212_ + x, this.f_107213_ + y, this.f_107214_ + z);
        this.particles.add(particle);
        Minecraft.m_91087_().f_91061_.m_107344_(p);
    }

    @Override
    public void summonParticle(ParticleOptions particle, double x, double y, double z, double dx, double dy, double dz) {
        this.f_107208_.m_7106_(particle, this.f_107212_ + x, this.f_107213_ + y, this.f_107214_ + z, dx, dy, dz);
    }

    @Override
    public void setLifetime(float time) {
        if (this.lifetime.getValue() < time || time == 0.0f) {
            this.lifetime.setValue(time);
        }
    }

    @Override
    public int getSpawnedParticles() {
        return this.particles.size();
    }

    @Override
    @Nullable
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    protected Component getPrefix() {
        return Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"[Emitter]").m_130940_(ChatFormatting.YELLOW)).m_7220_(super.getPrefix());
    }

    public void addMolangVariables(MolangVariableProvider.Context context) {
        context.addVariable("emitter_age", this.renderAge);
        context.addVariable("emitter_lifetime", this.lifetime);
        context.addVariable("emitter_random_1", this.random1);
        context.addVariable("emitter_random_2", this.random2);
        context.addVariable("emitter_random_3", this.random3);
        context.addVariable("emitter_random_4", this.random4);
        context.addVariable("particle_age", this.renderAge);
        context.addVariable("particle_lifetime", this.lifetime);
        context.addVariable("particle_random_1", this.random1);
        context.addVariable("particle_random_2", this.random2);
        context.addVariable("particle_random_3", this.random3);
        context.addVariable("particle_random_4", this.random4);
    }

    @Override
    @Nullable
    public ParticleRenderProperties getRenderProperties() {
        return null;
    }

    @Override
    public void setRenderProperties(@Nullable ParticleRenderProperties properties) {
    }

    @Override
    public BedrockParticleEmitter getEmitter() {
        return this;
    }

    public static class Provider
    implements ParticleProvider<BedrockParticleOption> {
        public Particle createParticle(BedrockParticleOption type, ClientLevel level, double x, double y, double z, double motionX, double motionY, double motionZ) {
            return new BedrockParticleEmitterImpl(null, level, x, y, z, type.getName());
        }
    }
}

