/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.render.particle.component;

import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.pinwheel.api.particle.component.ParticleMotionDynamicComponent;
import gg.moonflower.pollen.api.render.particle.v1.BedrockParticle;
import gg.moonflower.pollen.api.render.particle.v1.component.BedrockParticlePhysics;
import gg.moonflower.pollen.api.render.particle.v1.component.BedrockParticlePhysicsComponent;
import gg.moonflower.pollen.impl.render.particle.component.BedrockParticleComponentImpl;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@ApiStatus.Internal
public class ParticleMotionDynamicComponentImpl
extends BedrockParticleComponentImpl
implements BedrockParticlePhysicsComponent {
    private final ParticleMotionDynamicComponent data;
    private final Vector3d acceleration;

    public ParticleMotionDynamicComponentImpl(BedrockParticle particle, ParticleMotionDynamicComponent data) {
        super(particle);
        this.data = data;
        this.acceleration = new Vector3d();
    }

    @Override
    public void physicsTick() {
        BedrockParticlePhysics physics = this.getPhysics();
        MolangEnvironment environment = this.particle.getEnvironment();
        Vector3dc acceleration = physics.getAcceleration();
        float accelerationX = (float)(acceleration.x() + (double)environment.safeResolve(this.data.linearAcceleration()[0])) / 400.0f;
        float accelerationY = (float)(acceleration.y() + (double)environment.safeResolve(this.data.linearAcceleration()[1])) / 400.0f;
        float accelerationZ = (float)(acceleration.z() + (double)environment.safeResolve(this.data.linearAcceleration()[2])) / 400.0f;
        float drag = environment.safeResolve(this.data.linearDragCoefficient()) / 400.0f;
        Vector3dc velocity = physics.getVelocity();
        physics.setAcceleration((Vector3dc)this.acceleration.set((double)accelerationX - (double)drag * velocity.x(), (double)accelerationY - (double)drag * velocity.y(), (double)accelerationZ - (double)drag * velocity.z()));
        float rotationAcceleration = physics.getRotationAcceleration() + environment.safeResolve(this.data.rotationAcceleration()) / 400.0f;
        float rotationDrag = environment.safeResolve(this.data.rotationDragCoefficient()) / 400.0f;
        physics.setRotationAcceleration(rotationAcceleration - rotationDrag * physics.getRotationVelocity());
    }
}

