/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.render.particle.component;

import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.pinwheel.api.particle.ParticleInstance;
import gg.moonflower.pinwheel.api.particle.ParticleSourceObject;
import gg.moonflower.pinwheel.api.particle.component.ParticleEmitterShape;
import gg.moonflower.pollen.api.render.particle.v1.BedrockParticle;
import gg.moonflower.pollen.api.render.particle.v1.BedrockParticleEmitter;
import gg.moonflower.pollen.api.render.particle.v1.component.BedrockParticlePhysics;
import gg.moonflower.pollen.api.render.particle.v1.listener.BedrockParticleEmitterListener;
import gg.moonflower.pollen.impl.render.particle.component.BedrockParticleEmitterComponentImpl;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@ApiStatus.Internal
public class EmitterShapeComponentImpl
extends BedrockParticleEmitterComponentImpl
implements BedrockParticleEmitterListener,
ParticleEmitterShape.Spawner {
    private final ParticleEmitterShape data;
    private final Source source;

    public EmitterShapeComponentImpl(BedrockParticle particle, ParticleEmitterShape data) {
        super(particle);
        this.data = data;
        this.source = new Source();
    }

    @Override
    public void onEmitParticles(BedrockParticleEmitter emitter, int count) {
        this.data.emitParticles((ParticleEmitterShape.Spawner)this, count);
    }

    public BedrockParticle createParticle() {
        return this.particle.newParticle();
    }

    public void spawnParticle(ParticleInstance instance) {
        if (!(instance instanceof BedrockParticle)) {
            throw new AssertionError();
        }
        BedrockParticle bedrockParticle = (BedrockParticle)instance;
        Vector3dc pos = bedrockParticle.position();
        this.particle.summonParticle(bedrockParticle, pos.x(), pos.y(), pos.z());
    }

    @Nullable
    public ParticleSourceObject getEntity() {
        Entity entity = this.particle.getEntity();
        if (entity == null) {
            return null;
        }
        this.source.bounds = entity.m_20191_();
        return this.source;
    }

    public MolangEnvironment getEnvironment() {
        return this.particle.getEnvironment();
    }

    public Random getRandom() {
        return this.particle.getRandom();
    }

    public void setPosition(ParticleInstance instance, double x, double y, double z) {
        if (!(instance instanceof BedrockParticle)) {
            throw new AssertionError();
        }
        BedrockParticle bedrockParticle = (BedrockParticle)instance;
        bedrockParticle.setPosition(x, y, z);
    }

    public void setVelocity(ParticleInstance instance, double dx, double dy, double dz) {
        if (!(instance instanceof BedrockParticle)) {
            throw new AssertionError();
        }
        BedrockParticle bedrockParticle = (BedrockParticle)instance;
        BedrockParticlePhysics physics = bedrockParticle.getPhysics();
        if (physics == null) {
            return;
        }
        BedrockParticlePhysics emitterPhysics = this.particle.getPhysics();
        if (emitterPhysics != null) {
            Vector3dc velocity = emitterPhysics.getVelocity();
            dx += velocity.x();
            dy += velocity.y();
            dz += velocity.z();
        }
        physics.setVelocity((Vector3dc)new Vector3d(dx, dy, dz));
    }

    private static class Source
    implements ParticleSourceObject {
        private AABB bounds;

        private Source() {
        }

        public float getMinX() {
            return (float)this.bounds.f_82288_;
        }

        public float getMinY() {
            return (float)this.bounds.f_82289_;
        }

        public float getMinZ() {
            return (float)this.bounds.f_82290_;
        }

        public float getMaxX() {
            return (float)this.bounds.f_82291_;
        }

        public float getMaxY() {
            return (float)this.bounds.f_82292_;
        }

        public float getMaxZ() {
            return (float)this.bounds.f_82293_;
        }
    }
}

