/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.render.particle;

import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.molangcompiler.api.MolangEnvironmentBuilder;
import gg.moonflower.molangcompiler.api.MolangExpression;
import gg.moonflower.molangcompiler.api.exception.MolangRuntimeException;
import gg.moonflower.molangcompiler.api.object.MolangObject;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ProfilingMolangEnvironment
implements MolangEnvironment {
    private final MolangEnvironment environment;
    private final Supplier<ProfilerFiller> profiler;

    public ProfilingMolangEnvironment(MolangEnvironment environment, Supplier<ProfilerFiller> profiler) {
        this.environment = environment;
        this.profiler = profiler;
    }

    public void loadLibrary(String name, MolangObject object, String ... aliases) {
        this.environment.loadLibrary(name, object, aliases);
    }

    public void loadAlias(String name, String first, String ... aliases) throws IllegalArgumentException {
        this.environment.loadAlias(name, first, aliases);
    }

    public void loadParameter(float value) throws MolangRuntimeException {
        this.environment.loadParameter(value);
    }

    public void clearParameters() {
        this.environment.clearParameters();
    }

    public float getThis() {
        return this.environment.getThis();
    }

    public MolangObject get(String name) throws MolangRuntimeException {
        ProfilerFiller profiler = this.profiler.get();
        profiler.m_6180_("molang");
        MolangObject value = this.environment.get(name);
        profiler.m_7238_();
        return value;
    }

    public float getParameter(int parameter) throws MolangRuntimeException {
        return this.environment.getParameter(parameter);
    }

    public int getParameters() {
        return this.environment.getParameters();
    }

    public Collection<String> getObjects() {
        return this.environment.getObjects();
    }

    public void setThisValue(float thisValue) {
        this.environment.setThisValue(thisValue);
    }

    public boolean canEdit() {
        return this.environment.canEdit();
    }

    public MolangEnvironmentBuilder<MolangEnvironment> edit() throws IllegalStateException {
        return new ProfilingEnvironmentBuilder(this, (MolangEnvironmentBuilder<? extends MolangEnvironment>)this.environment.edit());
    }

    private record ProfilingEnvironmentBuilder(MolangEnvironment environment, MolangEnvironmentBuilder<? extends MolangEnvironment> builder) implements MolangEnvironmentBuilder<MolangEnvironment>
    {
        public MolangEnvironmentBuilder<MolangEnvironment> loadLibrary(String name, MolangObject object) {
            this.builder.loadLibrary(name, object);
            return this;
        }

        public MolangEnvironmentBuilder<MolangEnvironment> unloadLibrary(String name) {
            this.builder.unloadLibrary(name);
            return this;
        }

        public MolangEnvironmentBuilder<MolangEnvironment> setQuery(String name, MolangExpression value) {
            this.builder.setQuery(name, value);
            return this;
        }

        public MolangEnvironmentBuilder<MolangEnvironment> setGlobal(String name, MolangExpression value) {
            this.builder.setGlobal(name, value);
            return this;
        }

        public MolangEnvironmentBuilder<MolangEnvironment> setVariable(String name, MolangExpression value) {
            this.builder.setVariable(name, value);
            return this;
        }

        public MolangEnvironmentBuilder<MolangEnvironment> removeQuery(String name) {
            this.builder.removeQuery(name);
            return this;
        }

        public MolangEnvironmentBuilder<MolangEnvironment> removeGlobal(String name) {
            this.builder.removeGlobal(name);
            return this;
        }

        public MolangEnvironmentBuilder<MolangEnvironment> removeVariable(String name) {
            this.builder.removeVariable(name);
            return this;
        }

        public MolangEnvironmentBuilder<MolangEnvironment> clearLibraries() {
            this.builder.clearLibraries();
            return this;
        }

        public MolangEnvironmentBuilder<MolangEnvironment> clearQuery() {
            this.builder.clearQuery();
            return this;
        }

        public MolangEnvironmentBuilder<MolangEnvironment> clearGlobal() {
            this.builder.clearGlobal();
            return this;
        }

        public MolangEnvironmentBuilder<MolangEnvironment> clearVariable() {
            this.builder.clearVariable();
            return this;
        }

        public MolangEnvironmentBuilder<MolangEnvironment> copy(MolangEnvironment environment) {
            this.builder.copy(environment);
            return this;
        }

        public MolangEnvironment create() {
            return this.environment;
        }
    }
}

