/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.render.particle;

import gg.moonflower.pinwheel.api.particle.ParticleData;
import gg.moonflower.pinwheel.api.particle.ParticleParser;
import gg.moonflower.pollen.api.render.util.v1.BackgroundLoader;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class LocalParticleLoader
implements BackgroundLoader<Map<ResourceLocation, ParticleData>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FOLDER = "pinwheel/particles";

    @Override
    public CompletableFuture<Map<ResourceLocation, ParticleData>> reload(ResourceManager resourceManager, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, ParticleData> particleData = new HashMap<ResourceLocation, ParticleData>();
            try {
                for (Map.Entry entry : resourceManager.m_214159_(FOLDER, resourceLocation -> resourceLocation.m_135815_().endsWith(".json")).entrySet()) {
                    ResourceLocation particleLocation = (ResourceLocation)entry.getKey();
                    try {
                        BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                        try {
                            ParticleData particle = ParticleParser.parseParticle((Reader)reader);
                            ResourceLocation id = new ResourceLocation(particle.description().identifier());
                            if (particleData.put(id, particle) == null) continue;
                            LOGGER.warn("Duplicate particle: " + id);
                        }
                        finally {
                            if (reader == null) continue;
                            reader.close();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to load particle: " + particleLocation.m_135827_() + ":" + particleLocation.m_135815_().substring(FOLDER.length() + 1, particleLocation.m_135815_().length() - 5), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to load particles from: pinwheel/particles", (Throwable)e);
            }
            return particleData;
        }, backgroundExecutor);
    }
}

