/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.render.particle;

import gg.moonflower.pollen.api.render.particle.v1.component.BedrockParticlePhysics;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@ApiStatus.Internal
public class BedrockParticlePhysicsImpl
implements BedrockParticlePhysics {
    private final Vector3d direction = new Vector3d();
    private float speed = 0.0f;
    private final Vector3d velocity = new Vector3d();
    private final Vector3d acceleration = new Vector3d();
    private float rotationVelocity = 0.0f;
    private float rotationAcceleration = 0.0f;
    private float collisionRadius = 0.1f;
    private boolean collision = true;

    public void tick() {
        if (this.acceleration.lengthSquared() > 1.0E-7) {
            this.setVelocity((Vector3dc)this.getVelocity().add((Vector3dc)this.acceleration, this.velocity));
        }
    }

    @Override
    public Vector3dc getDirection() {
        return this.direction;
    }

    @Override
    public float getSpeed() {
        return this.speed;
    }

    @Override
    public Vector3dc getVelocity() {
        return this.direction.mul((double)this.speed, this.velocity);
    }

    @Override
    public Vector3dc getAcceleration() {
        return this.acceleration;
    }

    @Override
    public float getRotationVelocity() {
        return this.rotationVelocity;
    }

    @Override
    public float getRotationAcceleration() {
        return this.rotationAcceleration;
    }

    @Override
    public boolean hasCollision() {
        return this.collision;
    }

    @Override
    public float getCollisionRadius() {
        return this.collisionRadius;
    }

    @Override
    public void setDirection(double dx, double dy, double dz) {
        this.direction.set(dx, dy, dz);
        double lengthSq = this.direction.lengthSquared();
        if (lengthSq != 0.0) {
            this.direction.normalize();
        }
    }

    @Override
    public void setSpeed(float speed) {
        this.speed = Math.max(speed, 0.0f);
    }

    @Override
    public void setAcceleration(Vector3dc acceleration) {
        this.acceleration.set(acceleration);
    }

    @Override
    public void setRollVeclocity(float velocity) {
        this.rotationVelocity = velocity;
    }

    @Override
    public void setRotationAcceleration(float acceleration) {
        this.rotationAcceleration = acceleration;
    }

    @Override
    public void setCollision(boolean enabled) {
        this.collision = enabled;
    }

    @Override
    public void setCollisionRadius(float radius) {
        this.collisionRadius = radius;
    }
}

