/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.render.animation;

import dev.architectury.registry.ReloadListenerRegistry;
import gg.moonflower.pinwheel.api.animation.AnimationData;
import gg.moonflower.pollen.api.render.geometry.v1.GeometryModelManager;
import gg.moonflower.pollen.api.render.util.v1.BackgroundLoader;
import gg.moonflower.pollen.impl.render.animation.LocalAnimationLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class AnimationManagerImpl {
    private static final Logger LOGGER = LogManager.getLogger(GeometryModelManager.class);
    private static final Reloader RELOADER = new Reloader();
    private static final Set<BackgroundLoader<Map<ResourceLocation, AnimationData>>> LOADERS = new HashSet<BackgroundLoader<Map<ResourceLocation, AnimationData>>>();
    private static final Map<ResourceLocation, AnimationData> ANIMATIONS = new HashMap<ResourceLocation, AnimationData>();

    public static void init() {
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)RELOADER, (ResourceLocation)new ResourceLocation("pollen", "animation_manager"));
        AnimationManagerImpl.addLoader(new LocalAnimationLoader());
    }

    public static void addLoader(BackgroundLoader<Map<ResourceLocation, AnimationData>> loader) {
        LOADERS.add(loader);
    }

    public static AnimationData getAnimation(ResourceLocation location) {
        return ANIMATIONS.computeIfAbsent(location, key -> {
            LOGGER.warn("Unknown animation with key '{}'", (Object)location);
            return AnimationData.EMPTY;
        });
    }

    private static class Reloader
    implements PreparableReloadListener {
        private Reloader() {
        }

        public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            HashMap animationData = new HashMap();
            return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])LOADERS.stream().map(modelLoader -> modelLoader.reload(resourceManager, backgroundExecutor, gameExecutor).thenAcceptAsync(animations -> {
                for (Map.Entry entry : animations.entrySet()) {
                    if (animationData.put((ResourceLocation)entry.getKey(), (AnimationData)entry.getValue()) == null) continue;
                    LOGGER.warn("Duplicate animation: " + entry.getKey());
                }
            }, gameExecutor)).toArray(CompletableFuture[]::new)).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenRunAsync(() -> {
                LOGGER.info("Loaded " + animationData.size() + " animations.");
                ANIMATIONS.clear();
                ANIMATIONS.putAll(animationData);
            }, gameExecutor);
        }
    }
}

