/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.network.play;

import gg.moonflower.pinwheel.api.animation.AnimationController;
import gg.moonflower.pollen.api.animation.v1.controller.SerializableAnimationController;
import gg.moonflower.pollen.api.animation.v1.entity.AnimatedEntity;
import gg.moonflower.pollen.api.network.v1.packet.PollinatedPacketContext;
import gg.moonflower.pollen.core.network.play.ClientboundSetAnimationPacket;
import gg.moonflower.pollen.core.network.play.PollenClientMessageHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public class PollenClientMessageHandlerImpl
implements PollenClientMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollenClientMessageHandler.class);

    @Override
    public void handleSetAnimation(ClientboundSetAnimationPacket packet, PollinatedPacketContext ctx) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(packet.entityId());
        if (!(entity instanceof AnimatedEntity)) {
            LOGGER.warn("Failed to find animated entity with id: {}", (Object)packet.entityId());
            return;
        }
        AnimatedEntity animatedEntity = (AnimatedEntity)entity;
        AnimationController animationController = animatedEntity.getAnimationController();
        if (!(animationController instanceof SerializableAnimationController)) {
            LOGGER.warn("Entity with id {} does not have serializable animations", (Object)packet.entityId());
            return;
        }
        SerializableAnimationController controller = (SerializableAnimationController)animationController;
        ctx.enqueueWork(() -> controller.readFromNetwork(packet.data()));
    }
}

