/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets;

import java.util.function.Supplier;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import xerca.xercamusic.client.ClientStuff;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.packets.TripleNoteClientPacket;

public class TripleNoteClientPacketHandler {
    public static void handle(TripleNoteClientPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ctx.get().enqueueWork(() -> TripleNoteClientPacketHandler.processMessage(message));
        ctx.get().setPacketHandled(true);
    }

    private static void processMessage(TripleNoteClientPacket msg) {
        Entity entity = msg.getEntity();
        IItemInstrument.InsSound sound1 = msg.getInstrumentItem().getSound(msg.getNote1());
        IItemInstrument.InsSound sound2 = msg.getInstrumentItem().getSound(msg.getNote2());
        IItemInstrument.InsSound sound3 = msg.getInstrumentItem().getSound(msg.getNote3());
        if (sound1 == null || sound2 == null || sound3 == null) {
            return;
        }
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> ClientStuff.playNote(sound1.sound, x, y, z, SoundSource.PLAYERS, 1.5f, sound1.pitch, (byte)10));
        DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> ClientStuff.playNote(sound2.sound, x, y, z, SoundSource.PLAYERS, 1.5f, sound2.pitch, (byte)10));
        DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> ClientStuff.playNote(sound3.sound, x, y, z, SoundSource.PLAYERS, 1.5f, sound3.pitch, (byte)10));
    }
}

