/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.packets.MusicBoxUpdatePacket;
import xerca.xercamusic.common.tile_entity.TileEntityMusicBox;

public class MusicBoxUpdatePacketHandler {
    public static void handle(MusicBoxUpdatePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ctx.get().enqueueWork(() -> MusicBoxUpdatePacketHandler.processMessage(message));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void processMessage(MusicBoxUpdatePacket msg) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null || !world.m_46805_(msg.getPos())) {
            return;
        }
        BlockEntity te = world.m_7702_(msg.getPos());
        if (te instanceof TileEntityMusicBox) {
            TileEntityMusicBox tileEntityMusicBox = (TileEntityMusicBox)te;
            if (msg.getNoteStackNBT() != null) {
                if (msg.getNoteStackNBT().m_128456_()) {
                    tileEntityMusicBox.removeNoteStack();
                } else {
                    ItemStack noteStack = new ItemStack((ItemLike)Items.MUSIC_SHEET.get());
                    noteStack.m_41751_(msg.getNoteStackNBT());
                    tileEntityMusicBox.setNoteStack(noteStack, false);
                }
            }
            if (!msg.getInstrumentId().isEmpty()) {
                tileEntityMusicBox.setInstrument((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(msg.getInstrumentId())));
            } else {
                tileEntityMusicBox.removeInstrument();
            }
        }
    }
}

