/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import xerca.xercamusic.common.XercaMusic;

public class MusicBoxUpdatePacket {
    private BlockPos pos;
    private CompoundTag noteStackNBT;
    private String instrumentId;
    private boolean messageIsValid;

    public MusicBoxUpdatePacket(BlockPos pos, ItemStack noteStack, Item itemInstrument) {
        ResourceLocation resourcelocation;
        this.pos = pos;
        this.noteStackNBT = noteStack == null ? null : (noteStack.m_41782_() ? noteStack.m_41783_() : new CompoundTag());
        this.instrumentId = itemInstrument != null ? ((resourcelocation = ForgeRegistries.ITEMS.getKey((Object)itemInstrument)) == null ? "minecraft:air" : resourcelocation.toString()) : "";
    }

    public MusicBoxUpdatePacket() {
        this.messageIsValid = false;
    }

    public static MusicBoxUpdatePacket decode(FriendlyByteBuf buf) {
        MusicBoxUpdatePacket result = new MusicBoxUpdatePacket();
        try {
            result.pos = buf.m_130135_();
            result.noteStackNBT = buf.m_130260_();
            result.instrumentId = buf.m_130136_(255);
        }
        catch (IndexOutOfBoundsException ioe) {
            XercaMusic.LOGGER.error("Exception while reading MusicBoxUpdatePacket: " + ioe);
            return null;
        }
        result.messageIsValid = true;
        return result;
    }

    public static void encode(MusicBoxUpdatePacket pkt, FriendlyByteBuf buf) {
        buf.m_130064_(pkt.pos);
        buf.m_130079_(pkt.noteStackNBT);
        buf.m_130070_(pkt.instrumentId);
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }

    public CompoundTag getNoteStackNBT() {
        return this.noteStackNBT;
    }

    public String getInstrumentId() {
        return this.instrumentId;
    }

    public BlockPos getPos() {
        return this.pos;
    }
}

