/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.client;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import xerca.xercamusic.client.ClientStuff;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.tile_entity.TileEntityMusicBox;

public class SoundController
extends Thread {
    private final ArrayList<NoteEvent> notes;
    private volatile boolean doStop = false;
    private volatile double x;
    private volatile double y;
    private volatile double z;
    private final IItemInstrument instrument;
    private final byte bps;
    private final int spiritID;
    private final float volume;
    private TileEntityMusicBox musicBox = null;

    public SoundController(ArrayList<NoteEvent> notes, double x, double y, double z, IItemInstrument instrument, byte bps, float volume, int spiritID) {
        this.notes = notes;
        this.x = x;
        this.y = y;
        this.z = z;
        this.instrument = instrument;
        this.bps = bps;
        this.volume = volume;
        this.spiritID = spiritID;
    }

    public SoundController(ArrayList<NoteEvent> notes, double x, double y, double z, IItemInstrument instrument, byte bps, float volume, TileEntityMusicBox musicBox) {
        this(notes, x, y, z, instrument, bps, volume, -1);
        this.musicBox = musicBox;
    }

    private int beatsToTicks(int beats) {
        return Math.max(1, Math.round((float)beats * 20.0f / (float)this.bps));
    }

    @Override
    public void run() {
        if (this.bps == 0) {
            XercaMusic.LOGGER.error("BPS is 0! This should not happen!");
            return;
        }
        int msPerBeat = Math.round(1000.0f / (float)this.bps);
        int currentBeat = 0;
        for (NoteEvent event : this.notes) {
            if (this.doStop) {
                return;
            }
            while (event.time > currentBeat) {
                this.accurateSleep(msPerBeat);
                ++currentBeat;
                while (Minecraft.m_91087_().m_91104_()) {
                    this.inaccurateSleep(1L);
                }
                if (!this.doStop && Minecraft.m_91087_().f_91073_ != null) continue;
                return;
            }
            this.playNote(event);
        }
        if (this.spiritID >= 0) {
            Minecraft.m_91087_().m_18689_(() -> {
                if (Minecraft.m_91087_().f_91074_ != null) {
                    ClientStuff.endMusic(this.spiritID, Minecraft.m_91087_().f_91074_.m_19879_());
                }
            });
        }
    }

    private void playNote(NoteEvent event) {
        if (event.note >= 21 && event.note <= 117) {
            byte note = event.note;
            Minecraft.m_91087_().m_18689_(() -> {
                IItemInstrument.InsSound insSound = this.instrument.getSound(note);
                if (insSound == null) {
                    return;
                }
                if (this.musicBox == null) {
                    ClientStuff.playNote(insSound.sound, this.x, this.y, this.z, this.volume * event.floatVolume(), insSound.pitch, (byte)this.beatsToTicks(event.length));
                    if (Minecraft.m_91087_().f_91073_ != null) {
                        Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123758_, this.x, this.y + 2.2, this.z, (double)note / 24.0, 0.0, 0.0);
                    }
                } else {
                    ClientStuff.playNoteTE(insSound.sound, this.x, this.y, this.z, this.volume * event.floatVolume(), insSound.pitch, (byte)this.beatsToTicks(event.length));
                    if (Minecraft.m_91087_().f_91073_ != null) {
                        Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123758_, this.x + 0.5, this.y + 2.2, this.z + 0.5, (double)note / 24.0, 0.0, 0.0);
                    }
                }
            });
        }
    }

    public void setStop() {
        this.doStop = true;
    }

    public void setPos(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    private void accurateSleep(long millis) {
        if (millis == 0L) {
            return;
        }
        long start = System.currentTimeMillis();
        if (millis > 12L) {
            try {
                SoundController.sleep(millis - 10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        while (System.currentTimeMillis() < start + millis) {
        }
    }

    private void inaccurateSleep(long millis) {
        if (millis == 0L) {
            return;
        }
        try {
            SoundController.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

