/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.item.AncientWillContainer;
import vazkii.botania.common.item.AncientWillItem;

public class AncientWillRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<AncientWillRecipe> SERIALIZER = new SimpleRecipeSerializer(AncientWillRecipe::new);

    public AncientWillRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        boolean foundWill = false;
        boolean foundItem = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof AncientWillItem && !foundWill) {
                foundWill = true;
                continue;
            }
            if (foundItem) continue;
            if (stack.m_41720_() instanceof AncientWillContainer) {
                foundItem = true;
                continue;
            }
            return false;
        }
        return foundWill && foundItem;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv) {
        ItemStack item = ItemStack.f_41583_;
        AncientWillContainer.AncientWillType will = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof AncientWillContainer && item.m_41619_()) {
                item = stack;
                continue;
            }
            will = ((AncientWillItem)stack.m_41720_()).type;
        }
        AncientWillContainer container = (AncientWillContainer)item.m_41720_();
        if (container.hasAncientWill(item, will)) {
            return ItemStack.f_41583_;
        }
        ItemStack copy = item.m_41777_();
        container.addAncientWill(copy, will);
        return copy;
    }

    public boolean m_8004_(int width, int height) {
        return width > 1 || height > 1;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

