/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.item.ManaBlasterItem;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ManaBlasterTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = ResourceLocationHelper.prefix("fire_mana_blaster");
    public static final ManaBlasterTrigger INSTANCE = new ManaBlasterTrigger();

    private ManaBlasterTrigger() {
    }

    @NotNull
    public ResourceLocation m_7295_() {
        return ID;
    }

    @NotNull
    public Instance createInstance(@NotNull JsonObject json, EntityPredicate.Composite playerPred, DeserializationContext conditions) {
        Boolean desu = json.get("desu") == null ? null : Boolean.valueOf(json.get("desu").getAsBoolean());
        return new Instance(playerPred, ItemPredicate.m_45051_((JsonElement)json.get("item")), EntityPredicate.m_36614_((JsonElement)json.get("user")), desu);
    }

    public void trigger(ServerPlayer player, ItemStack stack) {
        this.m_66234_(player, instance -> instance.test(stack, player));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate item;
        private final EntityPredicate user;
        @Nullable
        private final Boolean desu;

        public Instance(EntityPredicate.Composite entityPred, ItemPredicate count, EntityPredicate user, Boolean desu) {
            super(ID, entityPred);
            this.item = count;
            this.user = user;
            this.desu = desu;
        }

        @NotNull
        public ResourceLocation m_7294_() {
            return ID;
        }

        boolean test(ItemStack stack, ServerPlayer entity) {
            return this.item.m_45049_(stack) && this.user.m_36611_(entity, (Entity)entity) && (this.desu == null || this.desu == ManaBlasterItem.isSugoiKawaiiDesuNe(stack));
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject json = super.m_7683_(context);
            if (this.item != ItemPredicate.f_45028_) {
                json.add("item", this.item.m_45048_());
            }
            if (this.user != EntityPredicate.f_36550_) {
                json.add("user", this.user.m_36606_());
            }
            if (this.desu != null) {
                json.addProperty("desu", this.desu);
            }
            return json;
        }

        public ItemPredicate getItem() {
            return this.item;
        }

        public EntityPredicate getUser() {
            return this.user;
        }

        @Nullable
        public Boolean getDesu() {
            return this.desu;
        }
    }
}

