/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.glue;

import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import com.simibubi.create.content.contraptions.glue.SuperGlueSelectionHelper;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkEvent;

public class SuperGlueSelectionPacket
extends SimplePacketBase {
    private BlockPos from;
    private BlockPos to;

    public SuperGlueSelectionPacket(BlockPos from, BlockPos to) {
        this.from = from;
        this.to = to;
    }

    public SuperGlueSelectionPacket(FriendlyByteBuf buffer) {
        this.from = buffer.m_130135_();
        this.to = buffer.m_130135_();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.from);
        buffer.m_130064_(this.to);
    }

    @Override
    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            double range = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_() + 2.0;
            if (player.m_20238_(Vec3.m_82512_((Vec3i)this.to)) > range * range) {
                return;
            }
            if (!this.to.m_123314_((Vec3i)this.from, 25.0)) {
                return;
            }
            Set<BlockPos> group = SuperGlueSelectionHelper.searchGlueGroup(player.f_19853_, this.from, this.to, false);
            if (group == null) {
                return;
            }
            if (!group.contains(this.to)) {
                return;
            }
            if (!SuperGlueSelectionHelper.collectGlueFromInventory((Player)player, 1, true)) {
                return;
            }
            AABB bb = SuperGlueEntity.span(this.from, this.to);
            SuperGlueSelectionHelper.collectGlueFromInventory((Player)player, 1, false);
            SuperGlueEntity entity = new SuperGlueEntity(player.f_19853_, bb);
            player.f_19853_.m_7967_((Entity)entity);
            entity.spawnParticles();
            AllAdvancements.SUPER_GLUE.awardTo((Player)player);
        });
        return true;
    }
}

