/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.data.worldgen;

import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.valhelsia.valhelsia_core.common.world.AddNetherSpawnsBiomeModifier;
import net.valhelsia.valhelsia_core.core.data.DataProviderInfo;

public abstract class ValhelsiaBiomeModifierProvider {
    private final DataProviderInfo info;
    private final RegistryOps<JsonElement> ops;
    private final Map<ResourceLocation, BiomeModifier> modifiers = new HashMap<ResourceLocation, BiomeModifier>();
    public final Registry<Biome> biomeRegistry;
    public final Registry<PlacedFeature> featureRegistry;
    public final HolderSet.Named<Biome> isOverworld;
    public final HolderSet.Named<Biome> isNether;
    public final HolderSet.Named<Biome> isEnd;

    public ValhelsiaBiomeModifierProvider(DataProviderInfo info, RegistryOps<JsonElement> ops) {
        this.info = info;
        this.ops = ops;
        this.biomeRegistry = (Registry)ops.m_206826_(Registry.f_122885_).orElseThrow();
        this.featureRegistry = (Registry)ops.m_206826_(Registry.f_194567_).orElseThrow();
        this.isOverworld = this.namedBiome((TagKey<Biome>)BiomeTags.f_215817_);
        this.isNether = this.namedBiome((TagKey<Biome>)BiomeTags.f_207612_);
        this.isEnd = this.namedBiome((TagKey<Biome>)BiomeTags.f_215818_);
        this.addModifiers();
    }

    protected abstract void addModifiers();

    public Map<ResourceLocation, BiomeModifier> getModifiers() {
        return this.modifiers;
    }

    public void addFeature(String name, HolderSet<Biome> biomes, HolderSet<PlacedFeature> features, GenerationStep.Decoration step) {
        this.add(name, (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(biomes, features, step));
    }

    public void addSpawn(String name, HolderSet<Biome> biomes, MobSpawnSettings.SpawnerData ... spawners) {
        this.add(name, (BiomeModifier)new ForgeBiomeModifiers.AddSpawnsBiomeModifier(biomes, List.of(spawners)));
    }

    public void addNetherSpawn(String name, HolderSet<Biome> biomes, double charge, double energyBudget, MobSpawnSettings.SpawnerData ... spawners) {
        this.add(name, new AddNetherSpawnsBiomeModifier(biomes, Optional.empty(), List.of(spawners), charge, energyBudget));
    }

    public void addNetherSpawn(String name, HolderSet<Biome> biomes, MobCategory category, double charge, double energyBudget, MobSpawnSettings.SpawnerData ... spawners) {
        this.add(name, new AddNetherSpawnsBiomeModifier(biomes, Optional.of(category), List.of(spawners), charge, energyBudget));
    }

    public void add(String name, BiomeModifier modifier) {
        this.modifiers.put(this.info.location(name), modifier);
    }

    public Registry<Biome> getBiomeRegistry() {
        return this.biomeRegistry;
    }

    public Registry<PlacedFeature> getFeatureRegistry() {
        return this.featureRegistry;
    }

    @SafeVarargs
    public final HolderSet<Biome> directBiome(ResourceKey<Biome> ... biomes) {
        return HolderSet.m_205809_((Holder[])((Holder[])Arrays.stream(biomes).map(arg_0 -> this.biomeRegistry.m_206081_(arg_0)).toArray(Holder[]::new)));
    }

    public final HolderSet.Named<Biome> namedBiome(TagKey<Biome> tagKey) {
        return new HolderSet.Named(this.biomeRegistry, tagKey);
    }

    @SafeVarargs
    public final HolderSet<PlacedFeature> directFeature(ResourceKey<PlacedFeature> ... features) {
        return HolderSet.m_205809_((Holder[])((Holder[])Arrays.stream(features).map(arg_0 -> this.featureRegistry.m_206081_(arg_0)).toArray(Holder[]::new)));
    }
}

