/*
 * Decompiled with CFR 0.152.
 */
package com.min01.archaeology.container;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public interface RandomizableContainer
extends Container {
    public static final String LOOT_TABLE_TAG = "LootTable";
    public static final String LOOT_TABLE_SEED_TAG = "LootTableSeed";

    @Nullable
    public ResourceLocation getLootTable();

    public void setLootTable(@Nullable ResourceLocation var1);

    default public void setLootTable(ResourceLocation lootTable, long lootTableSeed) {
        this.setLootTable(lootTable);
        this.setLootTableSeed(lootTableSeed);
    }

    public long getLootTableSeed();

    public void setLootTableSeed(long var1);

    public BlockPos m_58899_();

    @Nullable
    public Level m_58904_();

    public static void setBlockEntityLootTable(BlockGetter blockGetter, RandomSource random, BlockPos position, ResourceLocation lootTable) {
        BlockEntity blockEntity = blockGetter.m_7702_(position);
        if (blockEntity instanceof RandomizableContainer) {
            RandomizableContainer randomizableContainer = (RandomizableContainer)blockEntity;
            randomizableContainer.setLootTable(lootTable, random.m_188505_());
        }
    }

    default public boolean tryLoadLootTable(CompoundTag tag) {
        if (tag.m_128425_(LOOT_TABLE_TAG, 8)) {
            this.setLootTable(new ResourceLocation(tag.m_128461_(LOOT_TABLE_TAG)));
            this.setLootTableSeed(tag.m_128454_(LOOT_TABLE_SEED_TAG));
            return true;
        }
        return false;
    }

    default public boolean trySaveLootTable(CompoundTag tag) {
        ResourceLocation lootTable = this.getLootTable();
        if (lootTable == null) {
            return false;
        }
        tag.m_128359_(LOOT_TABLE_TAG, lootTable.toString());
        long lootTableSeed = this.getLootTableSeed();
        if (lootTableSeed != 0L) {
            tag.m_128356_(LOOT_TABLE_SEED_TAG, lootTableSeed);
        }
        return true;
    }

    default public void unpackLootTable(@Nullable Player player) {
        Level level = this.m_58904_();
        BlockPos position = this.m_58899_();
        ResourceLocation lootTableRaw = this.getLootTable();
        if (lootTableRaw != null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootTable lootTable = serverLevel.m_7654_().m_129898_().m_79217_(lootTableRaw);
            LootContext.Builder builder = new LootContext.Builder(serverLevel).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)position));
            this.setLootTable(null);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10563_.m_54597_(serverPlayer, lootTableRaw);
                builder.m_78963_(serverPlayer.m_36336_()).m_78972_(LootContextParams.f_81455_, (Object)serverPlayer);
            }
            lootTable.m_79123_((Container)this, builder.m_78975_(LootContextParamSets.f_81411_));
        }
    }
}

