/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.wall.vanilla;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.blockstate.BlockstateJson;
import com.ldtteam.datagenerators.blockstate.BlockstateModelJson;
import com.ldtteam.datagenerators.blockstate.BlockstateVariantJson;
import com.ldtteam.datagenerators.blockstate.multipart.MultipartCaseJson;
import com.ldtteam.datagenerators.blockstate.multipart.MultipartWhenJson;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.util.DataGeneratorConstants;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.WallSide;
import org.jetbrains.annotations.NotNull;

public class WallBlockStateProvider
implements DataProvider {
    private final DataGenerator generator;

    public WallBlockStateProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_213708_(@NotNull CachedOutput cache) throws IOException {
        this.createBlockstateFile(cache, ModBlocks.getInstance().getWall());
    }

    private void createBlockstateFile(CachedOutput cache, com.ldtteam.domumornamentum.block.vanilla.WallBlock wallBlock) throws IOException {
        if (wallBlock.getRegistryName() == null) {
            return;
        }
        ArrayList cases = Lists.newArrayList();
        cases.add(new MultipartCaseJson(new BlockstateVariantJson(new BlockstateModelJson("domum_ornamentum:block/walls/wall_post")), new MultipartWhenJson(WallBlock.f_57949_.m_61708_().toLowerCase(), "true")));
        for (Direction possibleValue : HorizontalDirectionalBlock.f_54117_.m_6908_()) {
            for (WallSide value : WallSide.values()) {
                if (value == WallSide.NONE) continue;
                cases.add(new MultipartCaseJson(new BlockstateVariantJson(new BlockstateModelJson("domum_ornamentum:block/walls/wall_side" + (value == WallSide.TALL ? "_tall" : ""), 0, this.getYFromFacing(possibleValue))), new MultipartWhenJson(possibleValue.m_122433_().toLowerCase(Locale.ROOT), value.toString())));
            }
        }
        BlockstateJson blockstate = new BlockstateJson((List)cases);
        Path blockstateFolder = this.generator.m_123916_().resolve("assets/domum_ornamentum/blockstates/");
        Path blockstatePath = blockstateFolder.resolve(wallBlock.getRegistryName().m_135815_() + ".json");
        DataProvider.m_236072_((CachedOutput)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)blockstate), (Path)blockstatePath);
    }

    @NotNull
    public String m_6055_() {
        return "Wall BlockStates Provider";
    }

    private int getYFromFacing(Direction facing) {
        switch (facing) {
            default: {
                return 0;
            }
            case EAST: {
                return 90;
            }
            case SOUTH: {
                return 180;
            }
            case WEST: 
        }
        return 270;
    }
}

