/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.TagParser;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class SkinFileUtils {
    public static String normalize(String filename) {
        return FilenameUtils.normalize((String)filename);
    }

    public static String normalize(String filename, boolean unixSeparator) {
        return FilenameUtils.normalize((String)filename, (boolean)unixSeparator);
    }

    public static String normalizeNoEndSeparator(String filename, boolean unixSeparator) {
        return FilenameUtils.normalizeNoEndSeparator((String)filename, (boolean)unixSeparator);
    }

    public static String concat(String basePath, String fullFilenameToAdd) {
        return FilenameUtils.concat((String)basePath, (String)fullFilenameToAdd);
    }

    public static File[] listFiles(File directory) {
        try {
            return directory.listFiles();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static String getBaseName(String filename) {
        return FilenameUtils.getBaseName((String)filename);
    }

    public static String removeExtension(String filename) {
        return FilenameUtils.removeExtension((String)filename);
    }

    public static String getExtension(String filename) {
        return FilenameUtils.getExtension((String)filename);
    }

    public static String getRelativePath(String path, String rootPath) {
        if (path.equals(rootPath)) {
            return "/";
        }
        if (path.startsWith(rootPath)) {
            return path.substring(rootPath.length());
        }
        return path;
    }

    public static String getRelativePath(String path, String rootPath, boolean unixSeparator) {
        return SkinFileUtils.normalize(SkinFileUtils.getRelativePath(path, rootPath), unixSeparator);
    }

    public static String getRelativePath(File path, File rootPath) {
        return SkinFileUtils.getRelativePath(path.getAbsolutePath(), rootPath.getAbsolutePath());
    }

    public static String getRelativePath(File path, File rootPath, boolean unixSeparator) {
        return SkinFileUtils.normalize(SkinFileUtils.getRelativePath(path, rootPath), unixSeparator);
    }

    public static void forceMkdir(File directory) throws IOException {
        FileUtils.forceMkdir((File)directory);
    }

    public static void forceMkdirParent(File file) throws IOException {
        File parent = file.getParentFile();
        if (parent != null) {
            SkinFileUtils.forceMkdir(parent);
        }
    }

    public static boolean deleteQuietly(File file) {
        return FileUtils.deleteQuietly((File)file);
    }

    public static byte[] readFileToByteArray(File file) throws IOException {
        return FileUtils.readFileToByteArray((File)file);
    }

    public static byte[] readStreamToByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(5120);
        SkinFileUtils.transferTo(inputStream, outputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        return outputStream.toByteArray();
    }

    public static void copyInputStreamToFile(InputStream inputStream, File destination) throws IOException {
        int bytesRead;
        SkinFileUtils.forceMkdirParent(destination);
        FileOutputStream outputStream = new FileOutputStream(destination);
        byte[] buffer = new byte[8192];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            ((OutputStream)outputStream).write(buffer, 0, bytesRead);
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public static void transferTo(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
    }

    public static void writeNBT(CompoundTag compoundTag, File file) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);){
            NbtIo.m_128941_((CompoundTag)compoundTag, (DataOutput)dataOutputStream);
        }
    }

    public static CompoundTag readNBT(File file) throws IOException {
        CompoundTag tag;
        if (!file.exists()) {
            return null;
        }
        try (FileInputStream fileinputstream = new FileInputStream(file);
             DataInputStream datainputstream = new DataInputStream(fileinputstream);){
            tag = NbtIo.m_128934_((DataInput)datainputstream, (NbtAccounter)NbtAccounter.f_128917_);
        }
        return tag;
    }

    public static CompoundTag readNBT(String contents) {
        try {
            return TagParser.m_129359_((String)contents);
        }
        catch (Exception e) {
            return new CompoundTag();
        }
    }
}

