/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import moe.plushie.armourers_workshop.api.math.IRectangle3f;
import moe.plushie.armourers_workshop.api.math.IRectangle3i;
import moe.plushie.armourers_workshop.api.math.IVector3f;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShapeTesselator {
    public static void vector(IVector3f origin, PoseStack poseStack, MultiBufferSource buffers) {
        ShapeTesselator.vector(origin.getX(), origin.getY(), origin.getZ(), 1.0f, poseStack, buffers);
    }

    public static void vector(IVector3f origin, float length, PoseStack poseStack, MultiBufferSource buffers) {
        ShapeTesselator.vector(origin.getX(), origin.getY(), origin.getZ(), length, poseStack, buffers);
    }

    public static void vector(float x, float y, float z, float length, PoseStack poseStack, MultiBufferSource buffers) {
        ShapeTesselator.vector(x, y, z, x + length, y + length, z + length, poseStack, buffers);
    }

    public static void vector(float x, float y, float z, float w, float h, float d, PoseStack poseStack, MultiBufferSource buffers) {
        ShapeTesselator.vector(x, y, z, w, h, d, poseStack, buffers.m_6299_(SkinRenderType.lines()));
    }

    public static void vector(float x, float y, float z, float w, float h, float d, PoseStack poseStack, VertexConsumer builder) {
        Matrix4f pose = poseStack.m_85850_().m_85861_();
        Matrix3f normal = poseStack.m_85850_().m_85864_();
        float n = 0.02f;
        float m = 0.002f;
        float x0 = x - w * 0.5f;
        float y0 = y - h * 0.5f;
        float z0 = z - d * 0.5f;
        float x1 = x - w * m;
        float y1 = y - h * m;
        float z1 = z - d * m;
        float x2 = x + 0.0f;
        float y2 = y + 0.0f;
        float z2 = z + 0.0f;
        float x3 = x + w * m;
        float y3 = y + h * m;
        float z3 = z + d * m;
        float x4 = x + w * 0.5f;
        float y4 = y + h * 0.5f;
        float z4 = z + d * 0.5f;
        float x5 = x4 - w * n;
        float y5 = y4 - h * n;
        float z5 = z4 - d * n;
        builder.m_85982_(pose, x0, y2, z2).m_6122_(255, 0, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x4, y2, z2).m_6122_(255, 0, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x2, y0, z2).m_6122_(0, 255, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x2, y4, z2).m_6122_(0, 255, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x2, y2, z0).m_6122_(0, 0, 255, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x2, y2, z4).m_6122_(0, 0, 255, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x4, y2, z2).m_6122_(255, 0, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x5, y1, z1).m_6122_(255, 0, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x4, y2, z2).m_6122_(255, 0, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x5, y3, z1).m_6122_(255, 0, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x4, y2, z2).m_6122_(255, 0, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x5, y1, z3).m_6122_(255, 0, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x4, y2, z2).m_6122_(255, 0, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x5, y3, z3).m_6122_(255, 0, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x5, y1, z3).m_6122_(255, 0, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x5, y3, z3).m_6122_(255, 0, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x5, y3, z3).m_6122_(255, 0, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x5, y3, z1).m_6122_(255, 0, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x5, y3, z1).m_6122_(255, 0, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x5, y1, z1).m_6122_(255, 0, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x5, y1, z1).m_6122_(255, 0, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x5, y1, z3).m_6122_(255, 0, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x2, y4, z2).m_6122_(0, 255, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x1, y5, z1).m_6122_(0, 255, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x2, y4, z2).m_6122_(0, 255, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x3, y5, z1).m_6122_(0, 255, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x2, y4, z2).m_6122_(0, 255, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x1, y5, z3).m_6122_(0, 255, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x2, y4, z2).m_6122_(0, 255, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x3, y5, z3).m_6122_(0, 255, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x1, y5, z3).m_6122_(0, 255, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x3, y5, z3).m_6122_(0, 255, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x3, y5, z3).m_6122_(0, 255, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x3, y5, z1).m_6122_(0, 255, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x3, y5, z1).m_6122_(0, 255, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x1, y5, z1).m_6122_(0, 255, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x1, y5, z1).m_6122_(0, 255, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x1, y5, z3).m_6122_(0, 255, 0, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x2, y2, z4).m_6122_(0, 0, 255, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x1, y1, z5).m_6122_(0, 0, 255, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x2, y2, z4).m_6122_(0, 0, 255, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x1, y3, z5).m_6122_(0, 0, 255, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x2, y2, z4).m_6122_(0, 0, 255, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x3, y1, z5).m_6122_(0, 0, 255, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x2, y2, z4).m_6122_(0, 0, 255, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x3, y3, z5).m_6122_(0, 0, 255, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x3, y3, z5).m_6122_(0, 0, 255, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x1, y3, z5).m_6122_(0, 0, 255, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x1, y3, z5).m_6122_(0, 0, 255, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x1, y1, z5).m_6122_(0, 0, 255, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x1, y1, z5).m_6122_(0, 0, 255, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x3, y1, z5).m_6122_(0, 0, 255, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x3, y1, z5).m_6122_(0, 0, 255, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x3, y3, z5).m_6122_(0, 0, 255, 255).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
    }

    public static void stroke(AABB rect, UIColor color, PoseStack poseStack, MultiBufferSource buffers) {
        ShapeTesselator.stroke((float)rect.f_82288_, (float)rect.f_82289_, (float)rect.f_82290_, (float)rect.f_82291_, (float)rect.f_82292_, (float)rect.f_82293_, color, poseStack, buffers);
    }

    public static void stroke(IRectangle3f rect, UIColor color, PoseStack poseStack, MultiBufferSource buffers) {
        ShapeTesselator.stroke(rect.getMinX(), rect.getMinY(), rect.getMinZ(), rect.getMaxX(), rect.getMaxY(), rect.getMaxZ(), color, poseStack, buffers);
    }

    public static void stroke(IRectangle3i rect, UIColor color, PoseStack poseStack, MultiBufferSource buffers) {
        ShapeTesselator.stroke(rect.getMinX(), rect.getMinY(), rect.getMinZ(), rect.getMaxX(), rect.getMaxY(), rect.getMaxZ(), color, poseStack, buffers);
    }

    public static void stroke(float x0, float y0, float z0, float x1, float y1, float z1, UIColor color, PoseStack poseStack, MultiBufferSource buffers) {
        ShapeTesselator.fill(x0, y0, z0, x1, y1, z1, color, poseStack, buffers.m_6299_(SkinRenderType.lines()));
    }

    public static void fill(float x0, float y0, float z0, float x1, float y1, float z1, UIColor color, PoseStack poseStack, VertexConsumer builder) {
        Matrix4f pose = poseStack.m_85850_().m_85861_();
        Matrix3f normal = poseStack.m_85850_().m_85864_();
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int a = color.getAlpha();
        builder.m_85982_(pose, x0, y0, z0).m_6122_(r, g, b, a).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x1, y0, z0).m_6122_(r, g, b, a).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x0, y0, z0).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x0, y1, z0).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x0, y0, z0).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(pose, x0, y0, z1).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(pose, x1, y0, z0).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x1, y1, z0).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x1, y1, z0).m_6122_(r, g, b, a).m_85977_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x0, y1, z0).m_6122_(r, g, b, a).m_85977_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x0, y1, z0).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(pose, x0, y1, z1).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(pose, x0, y1, z1).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x0, y0, z1).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x0, y0, z1).m_6122_(r, g, b, a).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x1, y0, z1).m_6122_(r, g, b, a).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x1, y0, z1).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        builder.m_85982_(pose, x1, y0, z0).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        builder.m_85982_(pose, x0, y1, z1).m_6122_(r, g, b, a).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x1, y1, z1).m_6122_(r, g, b, a).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x1, y0, z1).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x1, y1, z1).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(pose, x1, y1, z0).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(pose, x1, y1, z1).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
    }
}

