/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.google.common.base.Charsets;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import moe.plushie.armourers_workshop.utils.StreamUtils;

public final class SerializeHelper {
    private SerializeHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file, Charset encoding) {
        FileInputStream inputStream = null;
        String text = null;
        try {
            inputStream = new FileInputStream(file);
            text = StreamUtils.toString(inputStream, encoding);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(inputStream);
                throw throwable;
            }
            StreamUtils.closeQuietly(inputStream);
        }
        StreamUtils.closeQuietly(inputStream);
        return text;
    }

    public static String readFile(InputStream inputStream, Charset encoding) throws IOException {
        return StreamUtils.toString(inputStream, encoding);
    }

    public static JsonElement readJsonFile(File file) {
        return SerializeHelper.readJsonFile(file, Charsets.UTF_8);
    }

    public static JsonElement readJsonFile(File file, Charset encoding) {
        return SerializeHelper.stringToJson(SerializeHelper.readFile(file, encoding));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, Charset encoding, String text) {
        FileOutputStream outputStream = null;
        try {
            SkinFileUtils.forceMkdirParent(file);
            outputStream = new FileOutputStream(file, false);
            byte[] data = text.getBytes(encoding);
            ((OutputStream)outputStream).write(data);
            outputStream.flush();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(outputStream);
                throw throwable;
            }
            StreamUtils.closeQuietly(outputStream);
        }
        StreamUtils.closeQuietly(outputStream);
    }

    public static void writeJsonFile(File file, Charset encoding, JsonElement json) {
        SerializeHelper.writeFile(file, encoding, json.toString());
    }

    public static void writeJsonFile(JsonElement json, File file) {
        SerializeHelper.writeFile(file, Charsets.UTF_8, json.toString());
    }

    public static JsonElement stringToJson(String jsonString) {
        try {
            JsonParser parser = new JsonParser();
            return parser.parse(jsonString);
        }
        catch (Exception e) {
            ModLog.error("Error parsing json.", new Object[0]);
            ModLog.error(e.getMessage(), new Object[0]);
            return null;
        }
    }
}

