/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import moe.plushie.armourers_workshop.api.common.IContainerLevelAccess;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.common.IPlayerDataSerializer;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureDescriptor;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModEntityProfiles;
import moe.plushie.armourers_workshop.utils.StreamUtils;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.util.Strings;

public class DataSerializers {
    public static final IEntitySerializer<CompoundTag> COMPOUND_TAG = DataSerializers.of(EntityDataSerializers.f_135042_);
    public static final IEntitySerializer<Integer> INT = DataSerializers.of(EntityDataSerializers.f_135028_);
    public static final IEntitySerializer<String> STRING = DataSerializers.of(EntityDataSerializers.f_135030_);
    public static final IEntitySerializer<Boolean> BOOLEAN = DataSerializers.of(EntityDataSerializers.f_135035_);
    public static final IEntitySerializer<Float> FLOAT = DataSerializers.of(EntityDataSerializers.f_135029_);
    public static final IEntitySerializer<Vec3> VECTOR_3D = new IEntitySerializer<Vec3>(){

        public void write(FriendlyByteBuf buffer, Vec3 pos) {
            buffer.writeDouble(pos.m_7096_());
            buffer.writeDouble(pos.m_7098_());
            buffer.writeDouble(pos.m_7094_());
        }

        public Vec3 read(FriendlyByteBuf buffer) {
            return new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
    };
    public static final IEntitySerializer<Vector3f> VECTOR_3F = new IEntitySerializer<Vector3f>(){

        public void write(FriendlyByteBuf buffer, Vector3f pos) {
            buffer.writeFloat(pos.getX());
            buffer.writeFloat(pos.getY());
            buffer.writeFloat(pos.getZ());
        }

        public Vector3f read(FriendlyByteBuf buffer) {
            return new Vector3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    public static final IEntitySerializer<IPaintColor> PAINT_COLOR = new IEntitySerializer<IPaintColor>(){

        public void write(FriendlyByteBuf buffer, IPaintColor color) {
            buffer.writeInt(color.getRawValue());
        }

        public IPaintColor read(FriendlyByteBuf buffer) {
            return PaintColor.of(buffer.readInt());
        }
    };
    public static final IEntitySerializer<PlayerTextureDescriptor> PLAYER_TEXTURE = new IEntitySerializer<PlayerTextureDescriptor>(){

        public void write(FriendlyByteBuf buffer, PlayerTextureDescriptor descriptor) {
            buffer.m_130079_(descriptor.serializeNBT());
        }

        public PlayerTextureDescriptor read(FriendlyByteBuf buffer) {
            return new PlayerTextureDescriptor(buffer.m_130260_());
        }
    };
    public static final IEntitySerializer<Exception> EXCEPTION = new IEntitySerializer<Exception>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(FriendlyByteBuf buffer, Exception exception) {
            OutputStream outputStream = null;
            ObjectOutputStream objectOutputStream = null;
            try {
                boolean compress = ModConfig.Common.enableServerCompressesSkins;
                buffer.writeBoolean(compress);
                outputStream = this.createOutputStream(buffer, compress);
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(exception);
            }
            catch (Exception exception1) {
                try {
                    exception1.printStackTrace();
                }
                catch (Throwable throwable) {
                    StreamUtils.closeQuietly(objectOutputStream, outputStream);
                    throw throwable;
                }
                StreamUtils.closeQuietly(objectOutputStream, outputStream);
            }
            StreamUtils.closeQuietly(objectOutputStream, outputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Exception read(FriendlyByteBuf buffer) {
            Exception exception;
            InputStream inputStream = null;
            ObjectInputStream objectInputStream = null;
            try {
                boolean compress = buffer.readBoolean();
                inputStream = this.createInputStream(buffer, compress);
                objectInputStream = new ObjectInputStream(inputStream);
                exception = (Exception)objectInputStream.readObject();
            }
            catch (Exception exception2) {
                Exception exception3;
                try {
                    exception3 = exception2;
                }
                catch (Throwable throwable) {
                    StreamUtils.closeQuietly(objectInputStream, inputStream);
                    throw throwable;
                }
                StreamUtils.closeQuietly(objectInputStream, inputStream);
                return exception3;
            }
            StreamUtils.closeQuietly(objectInputStream, inputStream);
            return exception;
        }

        public Exception copy(Exception value) {
            return value;
        }

        private InputStream createInputStream(FriendlyByteBuf buffer, boolean compress) throws Exception {
            ByteBufInputStream inputStream = new ByteBufInputStream((ByteBuf)buffer);
            if (compress) {
                return new GZIPInputStream((InputStream)inputStream);
            }
            return inputStream;
        }

        private OutputStream createOutputStream(FriendlyByteBuf buffer, boolean compress) throws Exception {
            ByteBufOutputStream outputStream = new ByteBufOutputStream((ByteBuf)buffer);
            if (compress) {
                return new GZIPOutputStream((OutputStream)outputStream);
            }
            return outputStream;
        }
    };
    public static final IPlayerDataSerializer<SkinWardrobe> ENTITY_WARDROBE = new IPlayerDataSerializer<SkinWardrobe>(){

        @Override
        public void write(FriendlyByteBuf buffer, Player player, SkinWardrobe wardrobe) {
            buffer.writeInt(wardrobe.getId());
            buffer.m_130085_(wardrobe.getProfile().getRegistryName());
        }

        @Override
        public SkinWardrobe read(FriendlyByteBuf buffer, Player player) {
            if (player == null || player.m_9236_() == null) {
                return null;
            }
            int entityId = buffer.readInt();
            Entity entity = player.m_9236_().m_6815_(entityId);
            if (entity == null) {
                for (Player player1 : player.m_9236_().m_6907_()) {
                    if (player1.m_19879_() != entityId) continue;
                    entity = player1;
                    break;
                }
            }
            SkinWardrobe wardrobe = SkinWardrobe.of(entity);
            EntityProfile serverProfile = ModEntityProfiles.getProfile(buffer.m_130281_());
            if (wardrobe != null && serverProfile != null) {
                wardrobe.setProfile(serverProfile);
            }
            return wardrobe;
        }
    };
    public static final IPlayerDataSerializer<IContainerLevelAccess> WORLD_POS = new IPlayerDataSerializer<IContainerLevelAccess>(){

        @Override
        public void write(FriendlyByteBuf buffer, Player player, IContainerLevelAccess callable) {
            Optional pos1 = callable.m_6721_((world, pos) -> pos);
            buffer.m_130064_(pos1.orElse(BlockPos.f_121853_));
        }

        @Override
        public IContainerLevelAccess read(FriendlyByteBuf buffer, Player player) {
            if (player == null || player.m_9236_() == null) {
                return null;
            }
            BlockPos blockPos = buffer.m_130135_();
            return IContainerLevelAccess.create(player.m_9236_(), blockPos, null);
        }
    };
    public static final IPlayerDataSerializer<ISkinType> SKIN_TYPE = new IPlayerDataSerializer<ISkinType>(){

        @Override
        public void write(FriendlyByteBuf buffer, Player player, ISkinType value) {
            buffer.m_130070_(value.getRegistryName().toString());
        }

        @Override
        public ISkinType read(FriendlyByteBuf buffer, Player player) {
            return SkinTypes.byName(buffer.m_130136_(Short.MAX_VALUE));
        }
    };
    public static final IPlayerDataSerializer<SkinProperties> SKIN_PROPERTIES = new IPlayerDataSerializer<SkinProperties>(){

        @Override
        public void write(FriendlyByteBuf buffer, Player player, SkinProperties value) {
            CompoundTag nbt = new CompoundTag();
            value.writeToNBT(nbt);
            buffer.m_130079_(nbt);
        }

        @Override
        public SkinProperties read(FriendlyByteBuf buffer, Player player) {
            SkinProperties properties = SkinProperties.create();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                properties.readFromNBT(nbt);
            }
            return properties;
        }
    };
    private static final Random RANDOM = new Random();

    public static <T> IEntitySerializer<T> of(final EntityDataSerializer<T> serializer) {
        return new IEntitySerializer<T>(){

            @Override
            public T m_6709_(FriendlyByteBuf buffer) {
                return serializer.m_6709_(buffer);
            }

            @Override
            public void m_6856_(FriendlyByteBuf buffer, T descriptor) {
                serializer.m_6856_(buffer, descriptor);
            }
        };
    }

    public static void mirrorRotations(CompoundTag source, String sourceKey, Rotations sourceDefaultValue, CompoundTag target, String targetKey, Rotations targetDefaultValue) {
        Rotations rot = OptionalAPI.getOptionalRotations(source, sourceKey, sourceDefaultValue);
        rot = new Rotations(rot.m_123156_(), -rot.m_123157_(), -rot.m_123158_());
        OptionalAPI.putOptionalRotations(target, targetKey, rot, targetDefaultValue);
    }

    public static GameProfile readGameProfile(CompoundTag tag) {
        String name = null;
        UUID id = null;
        if (tag.m_128425_("Name", 8)) {
            name = tag.m_128461_("Name");
        }
        if (tag.m_128403_("Id")) {
            id = tag.m_128342_("Id");
        }
        try {
            return new GameProfile(id, name);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static CompoundTag writeGameProfile(CompoundTag tag, GameProfile value) {
        if (value == null) {
            return tag;
        }
        if (Strings.isNotBlank((String)value.getName())) {
            tag.m_128359_("Name", value.getName());
        }
        if (value.getId() != null) {
            tag.m_128362_("Id", value.getId());
        }
        return tag;
    }

    public static void dropContents(Level level, BlockPos blockPos, Container container) {
        DataSerializers.dropContents(level, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), container);
    }

    public static void dropContents(Level level, Entity entity, Container container) {
        DataSerializers.dropContents(level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), container);
    }

    private static void dropContents(Level level, double x, double y, double z, Container container) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            DataSerializers.dropItemStack(level, x, y, z, container.m_8020_(i));
        }
    }

    public static void dropContents(Level level, BlockPos blockPos, NonNullList<ItemStack> itemStacks) {
        itemStacks.forEach(itemStack -> DataSerializers.dropItemStack(level, blockPos, itemStack));
    }

    public static void dropItemStack(Level level, BlockPos blockPos, ItemStack itemStack) {
        DataSerializers.dropItemStack(level, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), itemStack);
    }

    public static void dropItemStack(Level level, double x, double y, double z, ItemStack itemStack) {
        double d0 = EntityType.f_20461_.m_20678_();
        double d1 = 1.0 - d0;
        double d2 = d0 / 2.0;
        double d3 = Math.floor(x) + RANDOM.nextDouble() * d1 + d2;
        double d4 = Math.floor(y) + RANDOM.nextDouble() * d1;
        double d5 = Math.floor(z) + RANDOM.nextDouble() * d1 + d2;
        while (!itemStack.m_41619_()) {
            ItemEntity itementity = new ItemEntity(level, d3, d4, d5, itemStack.m_41620_(RANDOM.nextInt(21) + 10));
            float f = 0.05f;
            itementity.m_20334_(RANDOM.nextGaussian() * (double)0.05f, RANDOM.nextGaussian() * (double)0.05f + (double)0.2f, RANDOM.nextGaussian() * (double)0.05f);
            level.m_7967_((Entity)itementity);
        }
    }
}

