/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform;

import java.io.File;
import java.util.ArrayList;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.core.data.LocalDataService;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.data.SkinServerType;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.network.ServerReplayPacket;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ReplayManager {
    private static boolean IS_REPLAYING = false;
    private static ArrayList<Runnable> REPLAY_CLEANER = new ArrayList();

    public static void init() {
    }

    public static void accept(ServerReplayPacket packet) {
        if (!IS_REPLAYING) {
            return;
        }
        switch (packet.getEvent()) {
            case START_RECORDING: {
                ReplayManager.clean();
                FriendlyByteBuf param = packet.getParameters();
                SkinServerType clientType = (SkinServerType)param.m_130066_(SkinServerType.class);
                if (clientType == SkinServerType.INTEGRATED_SERVER) {
                    File dbPath = new File(param.m_130277_());
                    if (dbPath.exists()) {
                        LocalDataService.start(dbPath);
                        REPLAY_CLEANER.add(LocalDataService::stop);
                    } else {
                        ModLog.warn("replay skin-database missing", new Object[0]);
                    }
                }
                SkinLoader.getInstance().prepare(clientType);
                SkinLoader.getInstance().start();
                REPLAY_CLEANER.add(() -> SkinLoader.getInstance().stop());
                break;
            }
            case STOP_RECORDING: {
                ReplayManager.clean();
            }
        }
    }

    public static void startReplay() {
        IS_REPLAYING = true;
    }

    public static void stopReplay() {
        IS_REPLAYING = false;
        ReplayManager.clean();
    }

    public static void startRecording(MinecraftServer server, Player player) {
        ReplayManager.sendTo(player, ServerReplayPacket.Event.START_RECORDING, buf -> {
            if (server.m_129792_() && server.m_7779_(player.m_36316_())) {
                buf.m_130068_((Enum)SkinServerType.INTEGRATED_SERVER);
                buf.m_130070_(EnvironmentManager.getSkinDatabaseDirectory().getPath());
                return;
            }
            buf.m_130068_((Enum)SkinServerType.CLIENT);
        });
    }

    public static void stopRecording(MinecraftServer server, Player player) {
        ReplayManager.sendTo(player, ServerReplayPacket.Event.STOP_RECORDING, null);
    }

    private static void sendTo(Player player, ServerReplayPacket.Event event, Consumer<FriendlyByteBuf> consumer) {
        NetworkManager.sendTo(new ServerReplayPacket(event, consumer), (ServerPlayer)player);
    }

    private static void clean() {
        REPLAY_CLEANER.forEach(Runnable::run);
        REPLAY_CLEANER.clear();
    }
}

