/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import moe.plushie.armourers_workshop.api.common.IResourceManager;
import moe.plushie.armourers_workshop.api.data.IDataPackBuilder;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.server.packs.resources.ResourceManager.Wrapper;
import moe.plushie.armourers_workshop.core.data.DataPackLoader;
import moe.plushie.armourers_workshop.core.data.DataPackType;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public class DataPackManager {
    private static final InDataResourceManager IN_DATA_RESOURCE_MANAGER = new InDataResourceManager();
    private static final InJarResourceManager IN_JAR_RESOURCE_MANAGER = new InJarResourceManager();

    public static void register(DataPackType packType, DataPackLoader loader) {
        switch (packType) {
            case JAR: {
                CompletableFuture<Map<ResourceLocation, IDataPackBuilder>> future = loader.prepare(IN_JAR_RESOURCE_MANAGER, Runnable::run);
                future.thenAccept(loader::load);
                break;
            }
            case DATA: {
                DataPackManager.IN_DATA_RESOURCE_MANAGER.loaders.add(loader);
                break;
            }
        }
    }

    public static InDataResourceManager getLoader() {
        return IN_DATA_RESOURCE_MANAGER;
    }

    public static class InJarResourceManager
    implements IResourceManager {
        private List<String> files;
        private final ClassLoader classLoader = InJarResourceManager.class.getClassLoader();

        @Override
        public boolean hasResource(ResourceLocation resourceLocation) {
            return this.getFiles().contains(this.resolve(resourceLocation));
        }

        @Override
        public InputStream readResource(ResourceLocation resourceLocation) throws IOException {
            return this.classLoader.getResourceAsStream(this.resolve(resourceLocation));
        }

        @Override
        public void readResources(ResourceLocation target, Predicate<String> validator, BiConsumer<ResourceLocation, InputStream> consumer) {
            String base = this.resolve(target.m_135827_(), "");
            this.getFiles().forEach(it -> {
                if (!it.startsWith(base)) {
                    return;
                }
                String name = SkinFileUtils.getRelativePath(it, base);
                if (!name.startsWith(target.m_135815_()) || !validator.test(name)) {
                    return;
                }
                InputStream stream = this.classLoader.getResourceAsStream((String)it);
                if (stream != null) {
                    consumer.accept(ModConstants.key(name), stream);
                }
            });
        }

        private String resolve(ResourceLocation location) {
            return this.resolve(location.m_135827_(), location.m_135815_());
        }

        private String resolve(String namespace, String path) {
            return "data/" + namespace + "/" + path;
        }

        private Collection<String> getFiles() {
            if (this.files != null) {
                return this.files;
            }
            ArrayList<String> results = new ArrayList<String>();
            InputStream inputStream = this.classLoader.getResourceAsStream("pack.dat");
            if (inputStream != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                try {
                    String file;
                    while ((file = reader.readLine()) != null) {
                        results.add(file);
                    }
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.files = results;
            return results;
        }
    }

    public static class InDataResourceManager
    implements PreparableReloadListener {
        private final ArrayList<DataPackLoader> loaders = new ArrayList();

        public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier barrier, ResourceManager resourceManager, ProfilerFiller profilerFiller, ProfilerFiller profilerFiller2, Executor executor, Executor executor2) {
            ArrayList tasks = new ArrayList();
            ArrayList entries = new ArrayList();
            IResourceManager resourceManager1 = Wrapper.asResourceManager(resourceManager);
            this.loaders.forEach(loader -> {
                CompletableFuture<Map<ResourceLocation, IDataPackBuilder>> future = loader.prepare(resourceManager1, executor);
                entries.add(future);
                tasks.add(() -> loader.load((Map)future.join()));
            });
            return ((CompletableFuture)CompletableFuture.allOf(entries.toArray(new CompletableFuture[0])).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).m_6769_(arg_0))).thenAcceptAsync(void_ -> tasks.forEach(Runnable::run), executor2);
        }
    }
}

