/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.command;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import moe.plushie.armourers_workshop.api.common.IArgumentSerializer;
import moe.plushie.armourers_workshop.api.common.IArgumentType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.FriendlyByteBuf;

public class ListArgumentType
implements IArgumentType<String> {
    private final Collection<String> list;

    public ListArgumentType(Collection<String> list) {
        this.list = list;
    }

    public static ListArgumentType list(Iterable<String> values) {
        return new ListArgumentType(Lists.newArrayList(values));
    }

    public static String getString(CommandContext<CommandSourceStack> context, String name) {
        return (String)context.getArgument(name, String.class);
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        String text = reader.getRemaining();
        for (String value : this.list) {
            if (!text.startsWith(value)) continue;
            reader.setCursor(reader.getCursor() + value.length());
            return value;
        }
        return text;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82970_(this.list, (SuggestionsBuilder)builder);
    }

    public static class Serializer
    implements IArgumentSerializer<ListArgumentType> {
        @Override
        public void serializeToNetwork(ListArgumentType argument, FriendlyByteBuf buffer) {
            ArrayList<String> lists = new ArrayList<String>(argument.list);
            buffer.writeInt(lists.size());
            lists.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130070_(arg_0));
        }

        @Override
        public ListArgumentType deserializeFromNetwork(FriendlyByteBuf buffer) {
            int size = buffer.readInt();
            ArrayList<String> lists = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                lists.add(buffer.m_130136_(Short.MAX_VALUE));
            }
            return new ListArgumentType(lists);
        }

        @Override
        public void serializeToJson(ListArgumentType argument, JsonObject json) {
            JsonArray array = new JsonArray();
            argument.list.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            json.add("items", (JsonElement)array);
        }
    }
}

