/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.config.IConfigBuilder;
import moe.plushie.armourers_workshop.api.config.IConfigSpec;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import moe.plushie.armourers_workshop.init.network.UpdateContextPacket;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.MathUtils;

public class ModConfigSpec {
    public static final IConfigSpec CLIENT = EnvironmentManager.getClientConfigSpec();
    public static final IConfigSpec COMMON = EnvironmentManager.getCommonConfigSpec();

    public static void init() {
        EnvironmentExecutor.didSetup(EnvironmentType.COMMON, () -> () -> COMMON.notify(() -> {
            if (EnvironmentManager.getServer() != null && EnvironmentManager.isDedicatedServer()) {
                NetworkManager.sendToAll(new UpdateContextPacket());
            }
        }));
    }

    public static abstract class Common
    extends ModConfig.Common
    implements IConfigBuilder {
        public Common() {
            this.defineCategory("general", "General settings.", () -> {
                this.defineInRange("maxUndos", 100, 0, 1000, "Max number of undos a player has for block painting.").bind(v -> {
                    maxUndos = v;
                }, () -> maxUndos);
                this.defineInRange("blockTaskRate", 10, 1, 1000, "Max number of processing blocks in per tick.").bind(v -> {
                    blockTaskRate = v;
                }, () -> blockTaskRate);
                this.define("lockDyesOnSkins", false, "When enabled players will not be able to remove dyes from skins in the dye table.").bind(v -> {
                    lockDyesOnSkins = v;
                }, () -> lockDyesOnSkins);
                this.define("instancedDyeTable", false, "If true the dye table will be instanced for each player. Items will be dropped when the table is closed.").bind(v -> {
                    instancedDyeTable = v;
                }, () -> instancedDyeTable);
                this.define("enableProtocolCheck", true, "If enabled the server will check the client protocol version in the login.", "Highly recommended unless the server does not support handshake.").bind(v -> {
                    enableProtocolCheck = v;
                }, () -> enableProtocolCheck);
                this.define("enablePermissionCheck", true, "If enabled the server will check permission node in the each operation.", "Highly recommended in the forge server.").bind(v -> {
                    enablePermissionCheck = v;
                }, () -> enablePermissionCheck);
                this.defineInRange("serverModelSendRate", 4000, 0, 8000, "The maximum number of skins the server is allow to send every minute.", "Less that 1 equals unlimited. (not recommended may cause bandwidth and cpu spikes on the server)").bind(n -> {
                    serverSkinSendRate = n;
                }, () -> serverSkinSendRate);
                this.define("serverCompressesSkins", true, "If enabled the server will compress skins before sending them to clients.", "Highly recommended unless the server has a very slow CPU.").bind(v -> {
                    enableServerCompressesSkins = v;
                }, () -> enableServerCompressesSkins);
                this.defineInRange("enableEmbeddedSkinRenderer", 0, 0, 2, "Using embedded skin renderer to replace the original item renderer.", "0 = use client config", "1 = always disable", "2 = always enable").bind(v -> {
                    enableEmbeddedSkinRenderer = v;
                }, () -> enableEmbeddedSkinRenderer);
                this.defineInRange("enableFirstPersonSkinRenderer", 0, 0, 2, "Using skin renderer to replace the original first person hands renderer.", "0 = use client config", "1 = always disable", "2 = always enable").bind(v -> {
                    enableFirstPersonSkinRenderer = v;
                }, () -> enableFirstPersonSkinRenderer);
            });
            this.defineCategory("wardrobe", "Setting for the players wardrobe.", () -> {
                this.define("allowOpening", true, "Allow the player to open the wardrobe GUI.").bind(v -> {
                    wardrobeAllowOpening = v;
                }, () -> wardrobeAllowOpening);
                this.define("enableSkinTab", true, "Enable the wardrobe skins tab.").bind(v -> {
                    showWardrobeSkins = v;
                }, () -> showWardrobeSkins);
                this.define("enableOutfitTab", true, "Enable the wardrobe outfits tab.").bind(v -> {
                    showWardrobeOutfits = v;
                }, () -> showWardrobeOutfits);
                this.define("enableDisplayTab", true, "Enable the wardrobe display settings tab.").bind(v -> {
                    showWardrobeDisplaySettings = v;
                }, () -> showWardrobeDisplaySettings);
                this.define("enableColourTab", true, "Enable the wardrobe colour settings tab.").bind(v -> {
                    showWardrobeColorSettings = v;
                }, () -> showWardrobeColorSettings);
                this.define("enableDyeTab", true, "Enable the wardrobe dyes tab.").bind(v -> {
                    showWardrobeDyeSetting = v;
                }, () -> showWardrobeDyeSetting);
                this.defineInRange("mobStartingSlots", 3, 1, SkinSlotType.getMaxSlotSize(), "Number of slot columns the mob starts with for skins.").bind(v -> {
                    prefersWardrobeMobSlots = v;
                }, () -> prefersWardrobeMobSlots);
                this.defineInRange("playerStartingSlots", 3, 1, SkinSlotType.getMaxSlotSize(), "Number of slot columns the player starts with for skins.").bind(v -> {
                    prefersWardrobePlayerSlots = v;
                }, () -> prefersWardrobePlayerSlots);
                this.defineInRange("playerDropSkinsOnDeath", 0, 0, 2, "Should skins be dropped on player death.", "0 = use keep inventory rule", "1 = never drop", "2 = always drop").bind(v -> {
                    prefersWardrobeDropOnDeath = v;
                }, () -> prefersWardrobeDropOnDeath);
            });
            this.defineCategory("library", "Setting for the library blocks.", () -> {
                this.define("allowDownloadingSkins", false, "Allows clients to save skins from a server to their local computer using the library.").bind(v -> {
                    allowDownloadingSkins = v;
                }, () -> allowDownloadingSkins);
                this.define("allowUploadingSkins", true, "Allows clients to load skins from their local computer onto the server using the library.").bind(v -> {
                    allowUploadingSkins = v;
                }, () -> allowUploadingSkins);
                this.define("extractOfficialSkins", true, "Allow the mod to extract the official skins that come with the mod into the library folder.").bind(v -> {
                    extractOfficialSkins = v;
                }, () -> extractOfficialSkins);
                this.define("allowPreviewSkins", true, "Shows model previews in the library.", "Causes a lot of extra load on servers.", "Best to turn off on high population servers").bind(n -> {
                    allowLibraryPreviews = n;
                }, () -> allowLibraryPreviews);
                this.define("allowManageSkins", false, "Allows clients to manage skins of the server computer library.", "Required permission level 5 or higher.").bind(v -> {
                    allowLibraryRemoteManage = v;
                }, () -> allowLibraryRemoteManage);
                this.defineList("skinServerURLs", new ArrayList(), this::allowsString, "We priority use https for the access token APIs.").bind(v -> {
                    customSkinServerURLs = new ArrayList(v);
                }, () -> new ArrayList(customSkinServerURLs));
            });
            this.defineCategory("holiday-events", "Enable/disable holiday events.", () -> this.define("disableAllHolidayEvents", false, "Setting to true will disable all holiday events. What's wrong with you!").bind(v -> {
                disableAllHolidayEvents = v;
            }, () -> disableAllHolidayEvents));
            this.defineCategory("cache", "Change (memory use/IO access) ratio by category setting in this category.", () -> {
                this.defineInRange("expireTime", 6000, 0, 36000, "How long in seconds the server will keep skins in it's cache.", "Default 600 seconds is 10 minutes.", "Setting to 0 turns off this option.").bind(v -> {
                    skinCacheExpireTime = v;
                }, () -> skinCacheExpireTime);
                this.defineInRange("maxSize", 2000, 0, 10000, "Max size the skin cache can reach before skins are removed.", "Setting to 0 turns off this option.").bind(v -> {
                    skinCacheMaxSize = v;
                }, () -> skinCacheMaxSize);
            });
            this.defineCategory("overrides", "Custom list of items that can be skinned.", () -> {
                this.defineList("itemOverrides", new ArrayList(), this::allowsString, "Format [\"override type:mod id:item name\"]", "Valid override types are: sword, shield, bow, pickaxe, axe, shovel, hoe and item", "example [\"sword:minecraft:iron_sword\",\"sword:minecraft:gold_sword\"]").bind(n -> {
                    overrides = new ArrayList(n);
                }, () -> new ArrayList(overrides));
                this.define("enableMatchingByItemId", true, "Tries to automatically assign the correct type of skin type without config and tag.").bind(v -> {
                    enableMatchingByItemId = v;
                }, () -> enableMatchingByItemId);
                this.defineList("matchingBlacklistByItemId", new ArrayList(), this::allowsString, "If the matching system wrong, you can add the item id here to this ignore it.").bind(v -> {
                    disableMatchingItems = new ArrayList(v);
                }, () -> new ArrayList(disableMatchingItems));
            });
        }

        public boolean allowsString(Object value) {
            return value instanceof String;
        }
    }

    public static abstract class Client
    extends ModConfig.Client
    implements IConfigBuilder {
        public Client() {
            this.defineCategory("general", "General settings.", () -> {
                this.defineInRange("enableEmbeddedSkinRenderer", 0, 0, 2, "Using embedded skin renderer to replace the original item renderer.", "0 = auto", "1 = disable", "2 = enable").bind(v -> {
                    enableEmbeddedSkinRenderer = v;
                }, () -> enableEmbeddedSkinRenderer);
                this.defineInRange("enableFirstPersonSkinRenderer", 0, 0, 2, "Using skin renderer to replace the original first person hands renderer.", "0 = auto", "1 = always disable", "2 = always enable").bind(v -> {
                    enableFirstPersonSkinRenderer = v;
                }, () -> enableFirstPersonSkinRenderer);
            });
            this.defineCategory("misc", "Miscellaneous settings.", () -> {
                this.defineInRange("skinLoadAnimationTime", 200, 0, 10000, "How long skins will display their loading animation for in milliseconds", "Settings this to 0 will disable loading animations.").bind(v -> {
                    skinLoadAnimationTime = v;
                }, () -> skinLoadAnimationTime);
                this.define("enableSkinLimitLimbs", true, "Whether allows skin to limit limbs of entities.").bind(v -> {
                    enableSkinLimitLimbs = v;
                }, () -> enableSkinLimitLimbs);
                this.define("enableClipInInventory", true, "Whether clip the excess skin in the inventory gui.").bind(v -> {
                    enableEntityInInventoryClip = v;
                }, () -> enableEntityInInventoryClip);
            });
            this.defineCategory("performance", "Change (visual quality/performance) ratio by changing setting in this category.", () -> {
                this.defineInRange("renderDistanceSkin", 128, 16, 512, "The max distance in blocks that skins will render.").bind(v -> {
                    renderDistanceSkin = v;
                }, () -> renderDistanceSkin);
                this.defineInRange("renderDistanceBlockSkin", 128, 16, 512, "The max distance in blocks that block skins will be rendered.").bind(v -> {
                    renderDistanceBlockSkin = v;
                }, () -> renderDistanceBlockSkin);
                this.defineInRange("renderDistanceMannequinEquipment", 64, 16, 512, "The max distance in blocks that equipment will be rendered on mannequins.").bind(v -> {
                    renderDistanceMannequinEquipment = v;
                }, () -> renderDistanceMannequinEquipment);
                this.defineInRange("modelBakingThreadCount", this.getBakingCores(), 1, 16, "The maximum number of threads that will be used to bake models. ", "[range: 1 ~ 16, default: core count / 2]").bind(v -> {
                    modelBakingThreadCount = v;
                }, () -> modelBakingThreadCount);
                this.define("multipassSkinRendering", true, "When enabled skin will render in multiple passes to reduce visual artifacts.", "Disabling this will improve skin rendering performance at the cost of visual quality.").bind(v -> {
                    multipassSkinRendering = v;
                }, () -> multipassSkinRendering);
                this.defineInRange("lodDistance", 32.0, 8.0, 128.0, "Distance away that skins will have lod applied to them.").bind(v -> {
                    lodDistance = v;
                }, () -> lodDistance);
                this.defineInRange("maxLodLevels", 4, 0, 4, "Number of LOD models to create. Higher number should give a boost to framerate at a small cost to VRAM.").bind(v -> {
                    maxLodLevels = v;
                }, () -> maxLodLevels);
            });
            this.defineCategory("cache", "Change (memory use/IO access) ratio by changing setting in this category.", () -> {
                this.defineInRange("skinCacheExpireTime", 600, 0, 3600, "How long in seconds the client will keep skins in it's cache.", "Default 600 seconds is 10 minutes.", "Setting to 0 turns off this option.").bind(v -> {
                    skinCacheExpireTime = v;
                }, () -> skinCacheExpireTime);
                this.defineInRange("skinCacheMaxSize", 2000, 0, 10000, "Max size the skin cache can reach before skins are removed.", "Setting to 0 turns off this option.").bind(v -> {
                    skinCacheMaxSize = v;
                }, () -> skinCacheMaxSize);
                this.defineInRange("modelPartCacheExpireTime", 600, 0, 3600, "How long in seconds the client will keep model parts in it's cache.", "Default 600 seconds is 10 minutes.", "Setting to 0 turns off this option.").bind(v -> {
                    modelPartCacheExpireTime = v;
                }, () -> modelPartCacheExpireTime);
                this.defineInRange("modelPartCacheMaxSize", 2000, 0, 10000, "Max size the cache can reach before model parts are removed.", "Setting to 0 turns off this option.").bind(v -> {
                    modelPartCacheMaxSize = v;
                }, () -> modelPartCacheMaxSize);
                this.defineInRange("textureCacheExpireTime", 600, 0, 3600, "How long in seconds the client will keep textures in it's cache", "Default 600 seconds is 10 minutes.", "Setting to 0 turns off this option.").bind(v -> {
                    textureCacheExpireTime = v;
                }, () -> textureCacheExpireTime);
                this.defineInRange("textureCacheMaxSize", 1000, 0, 5000, "Max size the texture cache can reach before textures are removed.", "Setting to 0 turns off this option.").bind(v -> {
                    textureCacheMaxSize = v;
                }, () -> textureCacheMaxSize);
                this.defineInRange("maxSkinRequests", 10, 1, 50, "Maximum number of skin the client can request at one time.").bind(v -> {
                    maxSkinRequests = v;
                }, () -> maxSkinRequests);
                this.defineInRange("fastCacheSize", 5000, 0, Integer.MAX_VALUE, "Size of client size cache.", "Setting to 0 turns off this option.").bind(v -> {
                    fastCacheSize = v;
                }, () -> fastCacheSize);
            });
            this.defineCategory("skin-preview", "Setting to configure the skin preview box.", () -> {
                this.define("skinPreEnabled", true, "Enables a larger skin preview box when hovering the mouse over a skin.").bind(n -> {
                    skinPreEnabled = n;
                }, () -> skinPreEnabled);
                this.define("skinPreDrawBackground", true, "Draw a background box for the skin preview.").bind(v -> {
                    skinPreDrawBackground = v;
                }, () -> skinPreDrawBackground);
                this.defineInRange("skinPreSize", 96, 16, 256, "Size of the skin preview.").bind(v -> {
                    skinPreSize = v;
                }, () -> skinPreSize);
                this.defineInRange("skinPreLocHorizontal", 0.0, 0.0, 1.0, "Horizontal location of the skin preview: 0 = left, 1 = right.").bind(v -> {
                    skinPreLocHorizontal = v;
                }, () -> skinPreLocHorizontal);
                this.defineInRange("skinPreLocVertical", 0.5, 0.0, 1.0, "Vertical location of the skin preview: 0 = top, 1 = bottom.").bind(v -> {
                    skinPreLocVertical = v;
                }, () -> skinPreLocVertical);
                this.define("skinPreLocFollowMouse", true, "Skin preview will be rendered next to the mouse.").bind(v -> {
                    skinPreLocFollowMouse = v;
                }, () -> skinPreLocFollowMouse);
            });
            this.defineCategory("tooltip", "Setting to configure tooltips on skinned items.", () -> {
                this.define("tooltipHasSkin", true, "Show has skin tooltip on skinned items.").bind(v -> {
                    tooltipHasSkin = v;
                }, () -> tooltipHasSkin);
                this.define("tooltipSkinName", true, "Show skin name tooltip on items.").bind(v -> {
                    tooltipSkinName = v;
                }, () -> tooltipSkinName);
                this.define("tooltipSkinAuthor", true, "Show skin author tooltip on items.").bind(v -> {
                    tooltipSkinAuthor = v;
                }, () -> tooltipSkinAuthor);
                this.define("tooltipSkinType", true, "Show skin type tooltip on items.").bind(v -> {
                    tooltipSkinType = v;
                }, () -> tooltipSkinType);
                this.define("tooltipFlavour", true, "Show skin flavoue text tooltip on items.").bind(v -> {
                    tooltipFlavour = v;
                }, () -> tooltipFlavour);
                this.define("tooltipOpenWardrobe", true, "Show open wardrobe message on skins.").bind(v -> {
                    tooltipOpenWardrobe = v;
                }, () -> tooltipOpenWardrobe);
            });
            this.defineCategory("debug", "Debug Settings.", () -> {
                this.define("shader", false, "Shows shader mixin results in logs.").bind(v -> {
                    enableShaderDebug = v;
                }, () -> enableShaderDebug);
                this.define("showF3DebugInfo", true, "Shows extra info on the F3 debug screen.").bind(v -> {
                    showF3DebugInfo = v;
                }, () -> showF3DebugInfo);
                this.defineInRange("texturePaintingType", 0, -1, 2, "Texture painting replacing the players texture with a painted version.", "Turning this off may fix issues with the players texture rendering", "incorrectly or showing the steve skin.", "", "-1 = disabled", "0 = auto", "1 = texture_replace (replaces the players texture - LEGACY)", "2 = model_replace_mc (render using a mc model - slower, more compatible - NOT IMPLEMENTED)", "3 = model_replace_aw (render using a aw model - faster, less compatible)").bind(n -> {
                    texturePaintingType = n;
                }, () -> texturePaintingType);
            });
        }

        private int getBakingCores() {
            int cores = Runtime.getRuntime().availableProcessors();
            int bakingCores = MathUtils.ceil((float)cores / 2.0f);
            return MathUtils.clamp(bakingCores, 1, 16);
        }
    }
}

