/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import java.util.function.Function;
import java.util.function.ToIntFunction;
import moe.plushie.armourers_workshop.api.registry.IBlockBuilder;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.builder.block.AdvancedSkinBuilderBlock;
import moe.plushie.armourers_workshop.builder.block.ArmourerBlock;
import moe.plushie.armourers_workshop.builder.block.BoundingBoxBlock;
import moe.plushie.armourers_workshop.builder.block.ColorMixerBlock;
import moe.plushie.armourers_workshop.builder.block.OutfitMakerBlock;
import moe.plushie.armourers_workshop.builder.block.SkinCubeBlock;
import moe.plushie.armourers_workshop.compatibility.api.AbstractBlockMaterial;
import moe.plushie.armourers_workshop.compatibility.api.AbstractBlockMaterialColor;
import moe.plushie.armourers_workshop.core.block.DyeTableBlock;
import moe.plushie.armourers_workshop.core.block.HologramProjectorBlock;
import moe.plushie.armourers_workshop.core.block.SkinnableBlock;
import moe.plushie.armourers_workshop.core.block.SkinningTableBlock;
import moe.plushie.armourers_workshop.init.platform.BuilderManager;
import moe.plushie.armourers_workshop.library.block.GlobalSkinLibraryBlock;
import moe.plushie.armourers_workshop.library.block.SkinLibraryBlock;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class ModBlocks {
    public static final IRegistryKey<Block> HOLOGRAM_PROJECTOR = (IRegistryKey)ModBlocks.normal(HologramProjectorBlock::new).lightLevel(ModBlocks.lit(13)).noOcclusion().strength(5.0f, 1200.0f).build("hologram-projector");
    public static final IRegistryKey<Block> SKINNABLE = (IRegistryKey)ModBlocks.half(SkinnableBlock::new).lightLevel(ModBlocks.lit(15)).noOcclusion().dynamicShape().build("skinnable");
    public static final IRegistryKey<Block> DYE_TABLE = (IRegistryKey)ModBlocks.half(DyeTableBlock::new).build("dye-table");
    public static final IRegistryKey<Block> SKINNING_TABLE = (IRegistryKey)ModBlocks.half(SkinningTableBlock::new).build("skinning-table");
    public static final IRegistryKey<Block> SKIN_LIBRARY_CREATIVE = (IRegistryKey)ModBlocks.half(SkinLibraryBlock::new).build("skin-library-creative");
    public static final IRegistryKey<Block> SKIN_LIBRARY = (IRegistryKey)ModBlocks.half(SkinLibraryBlock::new).build("skin-library");
    public static final IRegistryKey<Block> SKIN_LIBRARY_GLOBAL = (IRegistryKey)ModBlocks.half(GlobalSkinLibraryBlock::new).build("skin-library-global");
    public static final IRegistryKey<Block> OUTFIT_MAKER = (IRegistryKey)ModBlocks.half(OutfitMakerBlock::new).build("outfit-maker");
    public static final IRegistryKey<Block> COLOR_MIXER = (IRegistryKey)ModBlocks.normal(ColorMixerBlock::new).bind(() -> RenderType::m_110463_).build("colour-mixer");
    public static final IRegistryKey<Block> ARMOURER = (IRegistryKey)ModBlocks.normal(ArmourerBlock::new).build("armourer");
    public static final IRegistryKey<Block> ADVANCED_SKIN_BUILDER = (IRegistryKey)ModBlocks.normal(AdvancedSkinBuilderBlock::new).build("advanced-skin-builder");
    public static final IRegistryKey<Block> SKIN_CUBE = (IRegistryKey)ModBlocks.half(SkinCubeBlock::new).build("skin-cube");
    public static final IRegistryKey<Block> SKIN_CUBE_GLASS = (IRegistryKey)ModBlocks.glass(SkinCubeBlock::new).build("skin-cube-glass");
    public static final IRegistryKey<Block> SKIN_CUBE_GLOWING = (IRegistryKey)ModBlocks.half(SkinCubeBlock::new).lightLevel(15).build("skin-cube-glowing");
    public static final IRegistryKey<Block> SKIN_CUBE_GLASS_GLOWING = (IRegistryKey)ModBlocks.glass(SkinCubeBlock::new).lightLevel(15).build("skin-cube-glass-glowing");
    public static final IRegistryKey<Block> BOUNDING_BOX = (IRegistryKey)ModBlocks.glass(BoundingBoxBlock::new).noDrops().noCollission().build("bounding-box");

    private static ToIntFunction<BlockState> lit(int level) {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? level : 0;
    }

    private static IBlockBuilder<Block> create(Function<BlockBehaviour.Properties, Block> supplier, AbstractBlockMaterial material, AbstractBlockMaterialColor materialColor) {
        return BuilderManager.getInstance().createBlockBuilder(supplier, material, materialColor).strength(1.5f, 6.0f);
    }

    private static IBlockBuilder<Block> normal(Function<BlockBehaviour.Properties, Block> supplier) {
        return ModBlocks.create(supplier, AbstractBlockMaterial.STONE, AbstractBlockMaterialColor.NONE);
    }

    private static IBlockBuilder<Block> half(Function<BlockBehaviour.Properties, Block> supplier) {
        return ModBlocks.normal(supplier).noOcclusion().bind(() -> RenderType::m_110463_);
    }

    private static IBlockBuilder<Block> glass(Function<BlockBehaviour.Properties, Block> supplier) {
        return ModBlocks.create(supplier, AbstractBlockMaterial.GLASS, AbstractBlockMaterialColor.NONE).noOcclusion().bind(() -> RenderType::m_110466_);
    }

    public static void init() {
    }
}

