/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk;

import java.io.IOException;
import java.util.Collection;
import java.util.function.IntConsumer;
import moe.plushie.armourers_workshop.core.skin.data.base.IDataOutputStream;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.ChunkSerializer;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk.ChunkVariable;
import org.jetbrains.annotations.Nullable;

public class ChunkWriter {
    private final ChunkOutputStream stream;

    public ChunkWriter(ChunkOutputStream stream) {
        this.stream = stream;
    }

    public <V> void write(ChunkSerializer<V, Void> serializer, @Nullable V value) throws IOException {
        this.write(serializer, value, null);
    }

    public <V, T> void write(ChunkSerializer<V, T> serializer, @Nullable V value, T obj) throws IOException {
        if (serializer.isChunkEmpty(value)) {
            return;
        }
        int flags = serializer.getChunkFlags(value, this.stream.getContext());
        Sum sum = new Sum();
        this.stream.writeVariable(sum);
        this.stream.sumTask(sum, () -> {
            this.stream.writeString(serializer.getChunkType().getName(), 4);
            this.stream.writeShort(flags);
            this.stream.compressTask(flags, () -> serializer.write(value, obj, this.stream));
        });
    }

    public void writeBlobs(Object blobs) throws IOException {
        if (blobs instanceof Collection) {
            for (Object blob : (Collection)blobs) {
                if (!(blob instanceof ChunkVariable)) continue;
                ((ChunkVariable)blob).writeToStream(this.stream);
            }
        }
    }

    protected static class Sum
    implements IntConsumer,
    ChunkVariable {
        private int length = 0;
        private boolean resolved = false;

        protected Sum() {
        }

        @Override
        public void accept(int length) {
            this.length = length;
            this.resolved = true;
        }

        @Override
        public void writeToStream(IDataOutputStream stream) throws IOException {
            stream.writeInt(this.length + 4);
        }

        @Override
        public boolean freeze() {
            return this.resolved;
        }
    }
}

