/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk;

import com.google.common.collect.Iterators;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.IntConsumer;
import moe.plushie.armourers_workshop.core.skin.data.base.IDataOutputStream;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk.ChunkConsumer;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk.ChunkContext;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk.ChunkNode;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk.ChunkRunnable;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk.ChunkVariable;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk.ChunkWriter;

public class ChunkOutputStream
implements IDataOutputStream {
    private final ByteBuf buffer = Unpooled.buffer((int)1024);
    private final DataOutputStream outputStream = new DataOutputStream((OutputStream)new ByteBufOutputStream(this.buffer));
    private final DataOutputStream finalStream;
    private final ChunkContext context;
    private ChunkNode headNode;
    private ChunkNode tailNode;

    public ChunkOutputStream(DataOutputStream stream, ChunkContext context) {
        this.context = context;
        this.tailNode = this.headNode = new ChunkNode(0);
        this.finalStream = stream;
    }

    public void writeChunk(ChunkConsumer<ChunkWriter> consumer) throws IOException {
        consumer.accept(new ChunkWriter(this));
        this.writeInt(0);
    }

    public void writeVariable(ChunkVariable variable) throws IOException {
        this.appendVariable(variable);
    }

    public void flush() throws IOException {
        this.appendVariable(null);
        ChunkNode node = this.headNode;
        LinkedList<ChunkNode> pending = new LinkedList<ChunkNode>();
        while (node != null) {
            if (!node.freeze()) {
                pending.add(node);
            }
            node = node.next;
        }
        Iterator iterator = Iterators.cycle(pending);
        while (iterator.hasNext()) {
            if (!((ChunkNode)iterator.next()).freeze()) continue;
            iterator.remove();
        }
        byte[] bytes = this.buffer.array();
        node = this.headNode;
        while (node != null) {
            node.write(bytes, this.finalStream);
            ChunkNode next = node.next;
            node.next = null;
            node = next;
        }
        this.headNode = null;
        this.tailNode = null;
    }

    protected void sumTask(IntConsumer callback, ChunkRunnable runnable) throws IOException {
        ChunkNode start = this.appendVariable(null);
        runnable.run();
        this.appendNode(new ChunkNode.Sum(this.buffer.writerIndex(), start, callback));
    }

    protected void compressTask(int flags, ChunkRunnable runnable) throws IOException {
        if (flags == 0) {
            runnable.run();
            return;
        }
        ChunkNode start = this.appendVariable(null);
        this.appendNode(start);
        runnable.run();
        this.appendNode(new ChunkNode.Compressed(this.getBuffer().writerIndex(), start, flags, this));
    }

    @Override
    public DataOutputStream getOutputStream() {
        return this.outputStream;
    }

    protected ChunkContext getContext() {
        return this.context;
    }

    protected ByteBuf getBuffer() {
        return this.buffer;
    }

    protected ChunkNode appendVariable(ChunkVariable var) {
        ChunkNode node = ChunkNode.of(this.buffer.writerIndex(), var, this);
        return this.appendNode(node);
    }

    protected ChunkNode appendNode(ChunkNode node) {
        this.tailNode.next = node;
        this.tailNode = node;
        return node;
    }
}

