/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.cube;

import moe.plushie.armourers_workshop.api.skin.ISkinCubeProvider;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCube;
import moe.plushie.armourers_workshop.core.skin.data.SkinUsedCounter;
import moe.plushie.armourers_workshop.utils.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.utils.math.Vector3i;

public abstract class SkinCubes
implements ISkinCubeProvider {
    protected final SkinUsedCounter usedCounter = new SkinUsedCounter();

    public void forEach(ICubeConsumer consumer) {
        int count = this.getCubeCount();
        for (int i = 0; i < count; ++i) {
            Vector3i pos = this.getCube(i).getPos();
            consumer.apply(i, pos.getX(), pos.getY(), pos.getZ());
        }
    }

    public OpenVoxelShape getRenderShape() {
        OpenVoxelShape shape = OpenVoxelShape.empty();
        int count = this.getCubeCount();
        if (count == 0) {
            return shape;
        }
        for (int i = 0; i < count; ++i) {
            Vector3i pos = this.getCube(i).getPos();
            shape.add(pos.getX(), pos.getY(), pos.getZ(), 1.0f, 1.0f, 1.0f);
        }
        shape.optimize();
        return shape;
    }

    public SkinUsedCounter getUsedCounter() {
        return this.usedCounter;
    }

    @Override
    public abstract SkinCube getCube(int var1);

    public static interface ICubeConsumer {
        public void apply(int var1, int var2, int var3, int var4);
    }
}

