/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.api.common.IItemHandler;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.init.ModConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class LinkingToolItem
extends FlavouredItem
implements IItemHandler,
IItemPropertiesProvider {
    public LinkingToolItem(Item.Properties properties) {
        super(properties);
    }

    public static void setLinkedBlockPos(ItemStack itemStack, BlockPos pos) {
        OptionalAPI.putOptionalBlockPos(itemStack.m_41784_(), "LinkedPos", pos, null);
    }

    @Nullable
    public static BlockPos getLinkedBlockPos(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null) {
            return OptionalAPI.getOptionalBlockPos(tag, "LinkedPos", null);
        }
        return null;
    }

    @Override
    public void createModelProperties(BiConsumer<ResourceLocation, IItemModelProperty> builder) {
        builder.accept(ModConstants.key("empty"), (itemStack, level, entity, id) -> {
            CompoundTag tag = itemStack.m_41783_();
            if (tag != null && tag.m_128441_("LinkedPos")) {
                return 0.0f;
            }
            return 1.0f;
        });
    }

    @Override
    public InteractionResult useOnFirst(ItemStack itemStack, UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        if (level.m_5776_() || player == null) {
            return InteractionResult.SUCCESS;
        }
        BlockPos linkedBlockPos = LinkingToolItem.getLinkedBlockPos(itemStack);
        SkinnableBlockEntity blockEntity = this.getTitleEntity(level, context.m_8083_());
        if (blockEntity != null && player.m_6144_()) {
            blockEntity.setLinkedBlockPos(null);
            player.m_213846_((Component)Component.m_237115_((String)"inventory.armourers_workshop.linking-tool.clear"));
            return InteractionResult.SUCCESS;
        }
        if (linkedBlockPos != null) {
            LinkingToolItem.setLinkedBlockPos(itemStack, null);
            if (blockEntity != null) {
                blockEntity.setLinkedBlockPos(linkedBlockPos);
                player.m_213846_((Component)Component.m_237115_((String)"inventory.armourers_workshop.linking-tool.finish"));
                return InteractionResult.SUCCESS;
            }
            player.m_213846_((Component)Component.m_237115_((String)"inventory.armourers_workshop.linking-tool.fail"));
            return InteractionResult.SUCCESS;
        }
        if (blockEntity != null) {
            player.m_213846_((Component)Component.m_237115_((String)"inventory.armourers_workshop.linking-tool.linkedToSkinnable"));
            return InteractionResult.FAIL;
        }
        LinkingToolItem.setLinkedBlockPos(itemStack, context.m_8083_());
        player.m_213846_((Component)Component.m_237115_((String)"inventory.armourers_workshop.linking-tool.start"));
        return InteractionResult.SUCCESS;
    }

    private SkinnableBlockEntity getTitleEntity(Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof SkinnableBlockEntity) {
            return (SkinnableBlockEntity)blockEntity;
        }
        return null;
    }
}

