/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import java.util.List;
import moe.plushie.armourers_workshop.api.common.IItemGroup;
import moe.plushie.armourers_workshop.api.common.IItemGroupProvider;
import moe.plushie.armourers_workshop.api.common.IItemTintColorProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.core.holiday.Holiday;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.init.ModHolidays;
import moe.plushie.armourers_workshop.init.ModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class GiftSackItem
extends FlavouredItem
implements IItemGroupProvider,
IItemTintColorProvider {
    public GiftSackItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack of(Holiday holiday) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.GIFT_SACK.get());
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128359_("Holiday", holiday.getName());
        if (holiday.getHandler() != null) {
            nbt.m_128405_("Color1", holiday.getHandler().getBackgroundColor());
            nbt.m_128405_("Color2", holiday.getHandler().getForegroundColor());
        }
        return stack;
    }

    public static ItemStack getGift(ItemStack itemStack, Player player) {
        Holiday holiday = GiftSackItem.getHoliday(itemStack);
        if (holiday != null && holiday.getHandler() != null) {
            return holiday.getHandler().getGift(player);
        }
        CompoundTag itemNBT = itemStack.m_41737_("Gift");
        if (itemNBT != null) {
            return ItemStack.m_41712_((CompoundTag)itemNBT);
        }
        return ItemStack.f_41583_;
    }

    public static Holiday getHoliday(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt != null) {
            return ModHolidays.byName(nbt.m_128461_("Holiday"));
        }
        return null;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        ItemStack giftStack = GiftSackItem.getGift(itemStack, player);
        if (giftStack.m_41619_()) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (!level.m_5776_()) {
            if (player.m_150109_().m_36054_(giftStack)) {
                itemStack.m_41774_(1);
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"chat.armourers_workshop.inventoryFull"));
            }
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    @Override
    public void fillItemGroup(List<ItemStack> results, IItemGroup group) {
        for (Holiday holiday : ModHolidays.getHolidays()) {
            if (holiday.getHandler() == null) continue;
            results.add(GiftSackItem.of(holiday));
        }
    }

    @Override
    public int getTintColor(ItemStack itemStack, int index) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag == null) {
            return -1;
        }
        if (index == 1) {
            return OptionalAPI.getOptionalInt(tag, "Color2", 0x333333) | 0xFF000000;
        }
        return OptionalAPI.getOptionalInt(tag, "Color1", 0xFFFFFF) | 0xFF000000;
    }
}

