/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.color;

import java.util.HashMap;
import java.util.Set;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;

public class ColorDescriptor {
    private final HashMap<ISkinPaintType, Channel> channels = new HashMap();

    public void add(PaintColor color) {
        ISkinPaintType paintType = color.getPaintType();
        if (this.shouldRecordChannel(paintType)) {
            Channel ch = this.channels.computeIfAbsent(paintType, k -> new Channel());
            ch.red += color.getRed();
            ch.green += color.getGreen();
            ch.blue += color.getBlue();
            ++ch.total;
            ch.setChanged();
        }
    }

    public void add(ColorDescriptor descriptor) {
        descriptor.channels.forEach((paintType, otherChannel) -> {
            Channel ch = this.channels.computeIfAbsent((ISkinPaintType)paintType, k -> new Channel());
            ch.red += otherChannel.red;
            ch.green += otherChannel.green;
            ch.blue += otherChannel.blue;
            ch.total += otherChannel.total;
            ch.setChanged();
        });
    }

    public boolean isEmpty() {
        return this.channels.isEmpty();
    }

    public PaintColor getAverageColor(ISkinPaintType paintType) {
        Channel channel = this.channels.get(paintType);
        if (channel != null) {
            return channel.getResolvedColor();
        }
        return null;
    }

    public Set<ISkinPaintType> getPaintTypes() {
        return this.channels.keySet();
    }

    private boolean shouldRecordChannel(ISkinPaintType paintType) {
        if (paintType == SkinPaintTypes.RAINBOW) {
            return true;
        }
        if (paintType == SkinPaintTypes.TEXTURE) {
            return true;
        }
        return paintType.getDyeType() != null;
    }

    private static class Channel {
        int total = 0;
        int red = 0;
        int green = 0;
        int blue = 0;
        PaintColor resolvedColor;

        private Channel() {
        }

        void setChanged() {
            this.resolvedColor = null;
        }

        PaintColor getResolvedColor() {
            if (this.resolvedColor != null) {
                return this.resolvedColor;
            }
            if (this.total == 0) {
                this.resolvedColor = PaintColor.CLEAR;
                return this.resolvedColor;
            }
            int r = this.red / this.total;
            int g = this.green / this.total;
            int b = this.blue / this.total;
            this.resolvedColor = PaintColor.of(r << 16 | g << 8 | b, SkinPaintTypes.NORMAL);
            return this.resolvedColor;
        }
    }
}

