/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender;

import java.util.List;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRendererManager;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.utils.ModelHolder;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LivingSkinRenderer<T extends LivingEntity, M extends IModel>
extends SkinRenderer<T, M> {
    protected LivingEntityRenderer<T, ?> renderer;

    public LivingSkinRenderer(EntityProfile profile) {
        super(profile);
    }

    @Override
    protected void init(EntityRenderer<T> entityRenderer) {
        super.init(entityRenderer);
        if (entityRenderer instanceof LivingEntityRenderer) {
            this.replace((LivingEntityRenderer)entityRenderer);
        }
    }

    @Override
    public M getOverrideModel(M model) {
        return super.getOverrideModel(this.getResolvedModel(model));
    }

    @Override
    public int render(T entity, M model, BakedSkin bakedSkin, ColorScheme scheme, SkinRenderContext context) {
        return super.render(entity, this.getResolvedModel(model), bakedSkin, scheme, context);
    }

    public M getResolvedModel(M model) {
        if (model == null) {
            model = ModelHolder.of((Model)this.renderer.m_7200_());
        }
        return model;
    }

    private void replace(LivingEntityRenderer<T, EntityModel<T>> entityRenderer) {
        this.renderer = entityRenderer;
        SkinRendererManager.getInstance().applyPlugins(this, plugin -> {
            List layers = entityRenderer.f_115291_;
            for (int index = 0; index < layers.size(); ++index) {
                RenderLayer newValue = plugin.getOverrideLayer(entityRenderer, (RenderLayer)layers.get(index));
                if (newValue == null) continue;
                layers.set(index, newValue);
            }
        });
    }

    public static interface Plugin<T extends LivingEntity, M extends IModel> {
        public RenderLayer<T, EntityModel<T>> getOverrideLayer(LivingEntityRenderer<T, EntityModel<T>> var1, RenderLayer<T, EntityModel<T>> var2);
    }
}

