/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.util.HashMap;
import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.api.client.armature.IJoint;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelPart;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.SkinModelManager;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.init.platform.TransformationProvider;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public class SkinModelTransformer<T, M> {
    private final HashMap<ISkinPartType, Entry<T, M>> armors = new HashMap();
    private final HashMap<AbstractItemTransformType, Entry<T, M>> items = new HashMap();

    public static <M> void none(IPoseStack poseStack, M model) {
    }

    public static <T extends Entity, M extends IModel> void fromModel(IPoseStack poseStack, T entity, M model, BakedSkinPart bakedPart, BakedSkin bakedSkin, SkinRenderContext context) {
        ItemStack itemStack = context.getReference();
        AbstractItemTransformType transformType = context.getTransformType();
        float f1 = 16.0f;
        float f2 = 0.0625f;
        boolean flag = transformType == AbstractItemTransformType.THIRD_PERSON_LEFT_HAND || transformType == AbstractItemTransformType.FIRST_PERSON_LEFT_HAND;
        poseStack.scale(f1, f1, f1);
        BakedModel bakedModel = SkinModelManager.getInstance().getModel(bakedPart.getType(), itemStack, entity.m_9236_(), entity);
        TransformationProvider.handleTransforms(context.pose().pose(), bakedModel, transformType, flag);
        poseStack.scale(f2, f2, f2);
        if (flag) {
            poseStack.multiply(OpenMatrix4f.createScaleMatrix(-1.0f, 1.0f, 1.0f));
        }
    }

    public void registerArmor(ISkinPartType partType, IJoint joint) {
        this.registerArmor(partType, (IPoseStack poseStack, T entity, M model, BakedSkinPart bakedPart, BakedSkin bakedSkin, SkinRenderContext context) -> this.apply(poseStack, joint, context));
    }

    public void registerArmor(ISkinPartType partType, BiConsumer<IPoseStack, M> transformer) {
        this.registerArmor(partType, (IPoseStack poseStack, T entity, M model, BakedSkinPart bakedPart, BakedSkin bakedSkin, SkinRenderContext context) -> transformer.accept(poseStack, model));
    }

    public void registerArmor(ISkinPartType partType, Entry<T, M> transformer) {
        this.armors.put(partType, transformer);
    }

    public void registerItem(AbstractItemTransformType transformType, Entry<T, M> transformer) {
        this.items.put(transformType, transformer);
    }

    public void apply(IPoseStack poseStack, IJoint joint, SkinRenderContext context) {
        ITransformf transform;
        ITransformf[] transforms = context.getTransforms();
        if (transforms != null && (transform = transforms[joint.getId()]) != null) {
            transform.apply(poseStack);
        }
    }

    public void apply(IPoseStack poseStack, IModelPart modelPart) {
        if (modelPart != null) {
            modelPart.pose().transform(poseStack);
        }
    }

    public Entry<T, M> getArmour(ISkinPartType partType) {
        return this.armors.get(partType);
    }

    public Entry<T, M> getItem(AbstractItemTransformType transformType) {
        return this.items.get((Object)transformType);
    }

    @FunctionalInterface
    public static interface Entry<T, M> {
        public void apply(IPoseStack var1, T var2, M var3, BakedSkinPart var4, BakedSkin var5, SkinRenderContext var6);
    }
}

